/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.util.filter;

import mil.nga.sf.Geometry;
import mil.nga.sf.GeometryType;
import mil.nga.sf.Point;
import mil.nga.sf.util.SFException;
import mil.nga.sf.util.filter.FiniteFilterType;
import mil.nga.sf.util.filter.GeometryFilter;

public class PointFiniteFilter
implements GeometryFilter {
    private FiniteFilterType type = FiniteFilterType.FINITE;
    boolean filterZ = false;
    boolean filterM = false;

    public PointFiniteFilter() {
    }

    public PointFiniteFilter(FiniteFilterType type) {
        this.setType(type);
    }

    public PointFiniteFilter(FiniteFilterType type, boolean filterZ) {
        this.setType(type);
        this.setFilterZ(filterZ);
    }

    public PointFiniteFilter(FiniteFilterType type, boolean filterZ, boolean filterM) {
        this.setType(type);
        this.setFilterZ(filterZ);
        this.setFilterM(filterM);
    }

    public PointFiniteFilter(boolean filterZ) {
        this.setFilterZ(filterZ);
    }

    public PointFiniteFilter(boolean filterZ, boolean filterM) {
        this.setFilterZ(filterZ);
        this.setFilterM(filterM);
    }

    public FiniteFilterType getType() {
        return this.type;
    }

    public void setType(FiniteFilterType type) {
        this.type = type;
    }

    public boolean isFilterZ() {
        return this.filterZ;
    }

    public void setFilterZ(boolean filterZ) {
        this.filterZ = filterZ;
    }

    public boolean isFilterM() {
        return this.filterM;
    }

    public void setFilterM(boolean filterM) {
        this.filterM = filterM;
    }

    @Override
    public boolean filter(GeometryType containingType, Geometry geometry) {
        return geometry.getGeometryType() != GeometryType.POINT || !(geometry instanceof Point) || this.filter((Point)geometry);
    }

    private boolean filter(Point point) {
        return this.filter(point.getX()) && this.filter(point.getY()) && this.filterZ(point) && this.filterM(point);
    }

    private boolean filter(double value) {
        boolean passes;
        switch (this.type) {
            case FINITE: {
                passes = Double.isFinite(value);
                break;
            }
            case FINITE_AND_INFINITE: {
                passes = !Double.isNaN(value);
                break;
            }
            case FINITE_AND_NAN: {
                passes = !Double.isInfinite(value);
                break;
            }
            default: {
                throw new SFException("Unsupported filter type: " + this.type);
            }
        }
        return passes;
    }

    private boolean filterZ(Point point) {
        return !this.filterZ || !point.hasZ() || this.filter(point.getZ());
    }

    private boolean filterM(Point point) {
        return !this.filterM || !point.hasM() || this.filter(point.getM());
    }

    private boolean filter(Double value) {
        return value == null || this.filter((double)value);
    }
}

