/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.tiff.compression;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import mil.nga.tiff.compression.CompressionDecoder;
import mil.nga.tiff.compression.CompressionEncoder;
import mil.nga.tiff.io.IOUtils;
import mil.nga.tiff.util.TiffException;

public class DeflateCompression
implements CompressionDecoder,
CompressionEncoder {
    @Override
    public byte[] decode(byte[] bytes, ByteOrder byteOrder) {
        try {
            Inflater inflater = new Inflater();
            inflater.setInput(bytes);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(bytes.length);
            byte[] buffer = new byte[IOUtils.COPY_BUFFER_SIZE];
            while (!inflater.finished()) {
                int count = inflater.inflate(buffer);
                outputStream.write(buffer, 0, count);
            }
            outputStream.close();
            byte[] output = outputStream.toByteArray();
            return output;
        }
        catch (IOException e) {
            throw new TiffException("Failed close decoded byte stream", e);
        }
        catch (DataFormatException e) {
            throw new TiffException("Data format error while decoding stream", e);
        }
    }

    @Override
    public boolean rowEncoding() {
        return false;
    }

    @Override
    public byte[] encode(byte[] bytes, ByteOrder byteOrder) {
        try {
            Deflater deflater = new Deflater();
            deflater.setInput(bytes);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(bytes.length);
            deflater.finish();
            byte[] buffer = new byte[IOUtils.COPY_BUFFER_SIZE];
            while (!deflater.finished()) {
                int count = deflater.deflate(buffer);
                outputStream.write(buffer, 0, count);
            }
            outputStream.close();
            byte[] output = outputStream.toByteArray();
            return output;
        }
        catch (IOException e) {
            throw new TiffException("Failed close encoded stream", e);
        }
    }
}

