/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.serialization.api;

import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.BlockingIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import javax.annotation.Nullable;

final class BlockingIterableFlatMap<T, R>
implements BlockingIterable<R> {
    private static final Object NULL_PLACEHOLDER = new Object();
    private final BlockingIterable<T> original;
    private final Function<T, Iterable<R>> mapper;

    BlockingIterableFlatMap(BlockingIterable<T> original, Function<T, Iterable<R>> mapper) {
        this.original = Objects.requireNonNull(original);
        this.mapper = Objects.requireNonNull(mapper);
    }

    public BlockingIterator<R> iterator() {
        final BlockingIterator originalIterator = this.original.iterator();
        return new BlockingIterator<R>(){
            @Nullable
            private Iterator<R> intermediate;
            @Nullable
            private Object prefetched;

            public boolean hasNext(long timeout, TimeUnit unit) throws TimeoutException {
                if (this.prefetched != null) {
                    return true;
                }
                long remainingTimeoutNanos = unit.toNanos(timeout);
                long timeStampANanos = System.nanoTime();
                while (!this.tryFetchFromIntermediate()) {
                    if (!originalIterator.hasNext(remainingTimeoutNanos, TimeUnit.NANOSECONDS)) {
                        return false;
                    }
                    long timeStampBNanos = System.nanoTime();
                    this.intermediate = ((Iterable)BlockingIterableFlatMap.this.mapper.apply(originalIterator.next(remainingTimeoutNanos -= timeStampBNanos - timeStampANanos, TimeUnit.NANOSECONDS))).iterator();
                    timeStampANanos = System.nanoTime();
                    remainingTimeoutNanos -= timeStampANanos - timeStampBNanos;
                }
                return true;
            }

            @Nullable
            public R next(long timeout, TimeUnit unit) throws TimeoutException {
                if (!this.hasNext(timeout, unit)) {
                    throw new NoSuchElementException();
                }
                return this.resetPrefetchAndReturn();
            }

            public void close() throws Exception {
                originalIterator.close();
            }

            public boolean hasNext() {
                if (this.prefetched != null) {
                    return true;
                }
                while (!this.tryFetchFromIntermediate()) {
                    if (!originalIterator.hasNext()) {
                        return false;
                    }
                    this.intermediate = ((Iterable)BlockingIterableFlatMap.this.mapper.apply(originalIterator.next())).iterator();
                }
                return true;
            }

            @Nullable
            public R next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.resetPrefetchAndReturn();
            }

            private boolean tryFetchFromIntermediate() {
                if (this.intermediate != null) {
                    if (this.intermediate.hasNext()) {
                        this.prefetched = this.intermediate.next();
                        if (this.prefetched == null) {
                            this.prefetched = NULL_PLACEHOLDER;
                        }
                        return true;
                    }
                    this.intermediate = null;
                }
                return false;
            }

            @Nullable
            private R resetPrefetchAndReturn() {
                assert (this.prefetched != null);
                Object next = this.prefetched;
                this.prefetched = null;
                return this.unwrapNullPlaceHolder(next);
            }

            @Nullable
            private R unwrapNullPlaceHolder(Object next) {
                return next == NULL_PLACEHOLDER ? null : next;
            }
        };
    }
}

