/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.client.api;

import io.servicetalk.client.api.ConnectionFactory;
import io.servicetalk.client.api.ConnectionFactoryFilter;
import io.servicetalk.client.api.DelegatingConnectionFactory;
import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.concurrent.api.internal.SubscribableSingle;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.transport.api.ExecutionStrategy;
import io.servicetalk.transport.api.TransportObserver;
import java.net.ConnectException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.annotation.Nullable;

public final class LimitingConnectionFactoryFilter<ResolvedAddress, C extends ListenableAsyncCloseable>
implements ConnectionFactoryFilter<ResolvedAddress, C> {
    private final ConnectionLimiter<ResolvedAddress, C> limiter;

    private LimitingConnectionFactoryFilter(ConnectionLimiter<ResolvedAddress, C> limiter) {
        this.limiter = limiter;
    }

    @Override
    public ExecutionStrategy requiredOffloads() {
        return ExecutionStrategy.offloadNone();
    }

    public static <A, C extends ListenableAsyncCloseable> ConnectionFactoryFilter<A, C> withMax(int maxConnections) {
        return new LimitingConnectionFactoryFilter(new MaxConnectionsLimiter(maxConnections));
    }

    public static <A, C extends ListenableAsyncCloseable> ConnectionFactoryFilter<A, C> with(ConnectionLimiter<A, C> limiter) {
        return new LimitingConnectionFactoryFilter<A, C>(Objects.requireNonNull(limiter));
    }

    @Override
    public ConnectionFactory<ResolvedAddress, C> create(ConnectionFactory<ResolvedAddress, C> original) {
        return new LimitingFilter(original, this.limiter);
    }

    private static final class CountingSubscriber<A, C extends ListenableAsyncCloseable>
    implements SingleSource.Subscriber<C> {
        private static final AtomicIntegerFieldUpdater<CountingSubscriber> doneUpdater = AtomicIntegerFieldUpdater.newUpdater(CountingSubscriber.class, "done");
        private volatile int done;
        private final SingleSource.Subscriber<? super C> original;
        private final ConnectionLimiter<A, ? extends C> limiter;
        private final A address;

        CountingSubscriber(SingleSource.Subscriber<? super C> original, ConnectionLimiter<A, ? extends C> limiter, A address) {
            this.original = original;
            this.limiter = limiter;
            this.address = address;
        }

        public void onSubscribe(Cancellable cancellable) {
            this.original.onSubscribe(() -> {
                try {
                    this.sendCloseCallback();
                }
                finally {
                    cancellable.cancel();
                }
            });
        }

        public void onSuccess(@Nullable C result) {
            if (result == null) {
                try {
                    this.sendCloseCallback();
                }
                finally {
                    this.original.onError((Throwable)new ConnectException("Null connection received"));
                }
            } else {
                result.onClose().whenFinally(this::sendCloseCallback).subscribe();
                this.original.onSuccess(result);
            }
        }

        public void onError(Throwable t) {
            try {
                this.sendCloseCallback();
            }
            finally {
                this.original.onError(t);
            }
        }

        private void sendCloseCallback() {
            if (doneUpdater.compareAndSet(this, 0, 1)) {
                this.limiter.onConnectionClose(this.address);
            }
        }
    }

    private static final class MaxConnectionsLimiter<ResolvedAddress, C extends ListenableAsyncCloseable>
    implements ConnectionLimiter<ResolvedAddress, C> {
        private static final AtomicIntegerFieldUpdater<MaxConnectionsLimiter> countUpdater = AtomicIntegerFieldUpdater.newUpdater(MaxConnectionsLimiter.class, "count");
        private volatile int count;
        private final int maxAllowed;

        MaxConnectionsLimiter(int maxAllowed) {
            this.maxAllowed = maxAllowed;
        }

        @Override
        public boolean isConnectAllowed(ResolvedAddress target) {
            int c;
            do {
                if ((c = this.count) != this.maxAllowed) continue;
                return false;
            } while (!countUpdater.compareAndSet(this, c, c + 1));
            return true;
        }

        @Override
        public void onConnectionClose(ResolvedAddress target) {
            countUpdater.decrementAndGet(this);
        }
    }

    private static final class LimitingFilter<ResolvedAddress, C extends ListenableAsyncCloseable>
    extends DelegatingConnectionFactory<ResolvedAddress, C> {
        private final ConnectionLimiter<ResolvedAddress, C> limiter;

        private LimitingFilter(ConnectionFactory<ResolvedAddress, C> original, ConnectionLimiter<ResolvedAddress, C> limiter) {
            super(original);
            this.limiter = limiter;
        }

        @Override
        public Single<C> newConnection(final ResolvedAddress resolvedAddress, final @Nullable ContextMap context, final @Nullable TransportObserver observer) {
            return new SubscribableSingle<C>(){

                protected void handleSubscribe(SingleSource.Subscriber<? super C> subscriber) {
                    if (limiter.isConnectAllowed(resolvedAddress)) {
                        SourceAdapters.toSource(this.delegate().newConnection(resolvedAddress, context, observer)).subscribe(new CountingSubscriber(subscriber, limiter, resolvedAddress));
                    } else {
                        SubscriberUtils.deliverErrorFromSource(subscriber, (Throwable)limiter.newConnectionRefusedException(resolvedAddress));
                    }
                }
            };
        }
    }

    public static interface ConnectionLimiter<ResolvedAddress, C extends ListenableAsyncCloseable> {
        public boolean isConnectAllowed(ResolvedAddress var1);

        public void onConnectionClose(ResolvedAddress var1);

        default public Throwable newConnectionRefusedException(ResolvedAddress target) {
            return new ConnectException("No more connections allowed for the host: " + target);
        }
    }
}

