/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.internal;

import javax.annotation.Nullable;

public final class ThrowableUtils {
    private ThrowableUtils() {
    }

    public static <T extends Throwable> T unknownStackTrace(T cause, Class<?> clazz, String method) {
        cause.setStackTrace(new StackTraceElement[]{new StackTraceElement(clazz.getName(), method, null, -1)});
        return cause;
    }

    public static boolean matches(Throwable original, Class<? extends Throwable> toMatch) {
        if (original.getClass().isAssignableFrom(toMatch)) {
            return true;
        }
        for (Throwable lhs = original.getCause(); lhs != null; lhs = lhs.getCause()) {
            if (!lhs.getClass().isAssignableFrom(toMatch)) continue;
            return true;
        }
        return false;
    }

    public static Throwable catchUnexpected(@Nullable Throwable delayedCause, Throwable cause) {
        return delayedCause == null ? cause : delayedCause;
    }
}

