/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.internal;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.internal.EmptySubscriptions;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SubscriberUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriberUtils.class);

    private SubscriberUtils() {
    }

    public static boolean checkDuplicateSubscription(@Nullable PublisherSource.Subscription existing, PublisherSource.Subscription next) {
        if (existing != null) {
            next.cancel();
            return false;
        }
        return true;
    }

    public static boolean isRequestNValid(long n) {
        return n > 0L;
    }

    public static IllegalArgumentException newExceptionForInvalidRequestN(long n) {
        return new IllegalArgumentException("Rule 3.9 states non-positive request signals are illegal, but got: " + n);
    }

    public static <T> void deliverCompleteFromSource(PublisherSource.Subscriber<T> subscriber) {
        try {
            subscriber.onSubscribe(EmptySubscriptions.EMPTY_SUBSCRIPTION);
        }
        catch (Throwable t) {
            SubscriberUtils.handleExceptionFromOnSubscribe(subscriber, t);
            return;
        }
        SubscriberUtils.safeOnComplete(subscriber);
    }

    public static <T> void deliverSuccessFromSource(SingleSource.Subscriber<T> subscriber, @Nullable T value) {
        try {
            subscriber.onSubscribe(Cancellable.IGNORE_CANCEL);
        }
        catch (Throwable t) {
            SubscriberUtils.handleExceptionFromOnSubscribe(subscriber, t);
            return;
        }
        SubscriberUtils.safeOnSuccess(subscriber, value);
    }

    public static void deliverCompleteFromSource(CompletableSource.Subscriber subscriber) {
        try {
            subscriber.onSubscribe(Cancellable.IGNORE_CANCEL);
        }
        catch (Throwable t) {
            SubscriberUtils.handleExceptionFromOnSubscribe(subscriber, t);
            return;
        }
        SubscriberUtils.safeOnComplete(subscriber);
    }

    public static <T> void deliverErrorFromSource(PublisherSource.Subscriber<T> subscriber, Throwable cause) {
        try {
            subscriber.onSubscribe(EmptySubscriptions.EMPTY_SUBSCRIPTION);
        }
        catch (Throwable t) {
            SubscriberUtils.handleExceptionFromOnSubscribe(subscriber, t);
            return;
        }
        SubscriberUtils.safeOnError(subscriber, cause);
    }

    public static <T> void deliverErrorFromSource(SingleSource.Subscriber<T> subscriber, Throwable cause) {
        try {
            subscriber.onSubscribe(Cancellable.IGNORE_CANCEL);
        }
        catch (Throwable t) {
            SubscriberUtils.handleExceptionFromOnSubscribe(subscriber, t);
            return;
        }
        SubscriberUtils.safeOnError(subscriber, cause);
    }

    public static void deliverErrorFromSource(CompletableSource.Subscriber subscriber, Throwable cause) {
        try {
            subscriber.onSubscribe(Cancellable.IGNORE_CANCEL);
        }
        catch (Throwable t) {
            SubscriberUtils.handleExceptionFromOnSubscribe(subscriber, t);
            return;
        }
        SubscriberUtils.safeOnError(subscriber, cause);
    }

    public static <T> void handleExceptionFromOnSubscribe(PublisherSource.Subscriber<T> subscriber, Throwable cause) {
        SubscriberUtils.safeOnError(subscriber, cause);
        LOGGER.warn("Unexpected exception from onSubscribe of Subscriber {}.", subscriber, (Object)cause);
    }

    public static <T> void handleExceptionFromOnSubscribe(SingleSource.Subscriber<T> subscriber, Throwable cause) {
        SubscriberUtils.safeOnError(subscriber, cause);
        LOGGER.warn("Unexpected exception from onSubscribe of Subscriber {}.", subscriber, (Object)cause);
    }

    public static void handleExceptionFromOnSubscribe(CompletableSource.Subscriber subscriber, Throwable cause) {
        SubscriberUtils.safeOnError(subscriber, cause);
        LOGGER.warn("Unexpected exception from onSubscribe of Subscriber {}.", (Object)subscriber, (Object)cause);
    }

    public static void safeOnError(CompletableSource.Subscriber subscriber, Throwable cause) {
        try {
            subscriber.onError(cause);
        }
        catch (Throwable t) {
            LOGGER.info("Ignoring exception from onError of Subscriber {}.", (Object)subscriber, (Object)t);
        }
    }

    public static <T> void safeOnError(SingleSource.Subscriber<T> subscriber, Throwable cause) {
        try {
            subscriber.onError(cause);
        }
        catch (Throwable t) {
            LOGGER.info("Ignoring exception from onError of Subscriber {}.", subscriber, (Object)t);
        }
    }

    public static <T> void safeOnError(PublisherSource.Subscriber<T> subscriber, Throwable cause) {
        try {
            subscriber.onError(cause);
        }
        catch (Throwable t) {
            LOGGER.info("Ignoring exception from onError of Subscriber {}.", subscriber, (Object)t);
        }
    }

    public static <T> void safeOnComplete(PublisherSource.Subscriber<T> subscriber) {
        try {
            subscriber.onComplete();
        }
        catch (Throwable t) {
            LOGGER.info("Ignoring exception from onComplete of Subscriber {}.", subscriber, (Object)t);
        }
    }

    public static <T> void safeOnSuccess(SingleSource.Subscriber<T> subscriber, @Nullable T value) {
        try {
            subscriber.onSuccess(value);
        }
        catch (Throwable t) {
            LOGGER.info("Ignoring exception from onSuccess of Subscriber {}.", subscriber, (Object)t);
        }
    }

    public static void safeOnComplete(CompletableSource.Subscriber subscriber) {
        try {
            subscriber.onComplete();
        }
        catch (Throwable t) {
            LOGGER.info("Ignoring exception from onComplete of Subscriber {}.", (Object)subscriber, (Object)t);
        }
    }

    public static void safeCancel(Cancellable cancellable) {
        try {
            cancellable.cancel();
        }
        catch (Throwable t) {
            LOGGER.info("Ignoring exception from cancel {}.", (Object)cancellable, (Object)t);
        }
    }

    public static <T> void logDuplicateTerminal(PublisherSource.Subscriber<T> subscriber) {
        SubscriberUtils.logDuplicateTerminal0(subscriber, null);
    }

    public static <T> void logDuplicateTerminal(PublisherSource.Subscriber<T> subscriber, Throwable cause) {
        SubscriberUtils.logDuplicateTerminal0(subscriber, cause);
    }

    public static <T> void logDuplicateTerminal(SingleSource.Subscriber<T> subscriber) {
        SubscriberUtils.logDuplicateTerminal0(subscriber, null);
    }

    public static <T> void logDuplicateTerminalOnSuccess(SingleSource.Subscriber<T> subscriber, @Nullable T onSuccess) {
        SubscriberUtils.logDuplicateTerminal0(subscriber, new IllegalStateException("ignoring onSuccess: " + onSuccess));
    }

    public static <T> void logDuplicateTerminal(SingleSource.Subscriber<T> subscriber, Throwable cause) {
        SubscriberUtils.logDuplicateTerminal0(subscriber, cause);
    }

    private static void logDuplicateTerminal0(Object subscriber, @Nullable Throwable cause) {
        LOGGER.warn("onSubscribe not called before terminal or duplicate terminal on Subscriber {}", subscriber, (Object)new IllegalStateException("onSubscribe not called before terminal or duplicate terminal on Subscriber " + subscriber + " forbidden see: https://github.com/reactive-streams/reactive-streams-jvm/blob/v1.0.3/README.md#1.9https://github.com/reactive-streams/reactive-streams-jvm/blob/v1.0.3/README.md#1.7", cause));
    }
}

