/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.BlockingHttpService;
import io.servicetalk.http.api.BlockingStreamingHttpService;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpLifecycleObserver;
import io.servicetalk.http.api.HttpProtocolConfig;
import io.servicetalk.http.api.HttpServerBuilder;
import io.servicetalk.http.api.HttpServerContext;
import io.servicetalk.http.api.HttpService;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceFilterFactory;
import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.transport.api.ConnectionAcceptorFactory;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.transport.api.ServerSslConfig;
import io.servicetalk.transport.api.TransportObserver;
import java.net.SocketOption;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;

public class DelegatingHttpServerBuilder
implements HttpServerBuilder {
    private HttpServerBuilder delegate;

    public DelegatingHttpServerBuilder(HttpServerBuilder delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    protected final HttpServerBuilder delegate() {
        return this.delegate;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{delegate=" + this.delegate() + '}';
    }

    @Override
    public HttpServerBuilder protocols(HttpProtocolConfig ... protocols) {
        this.delegate = this.delegate.protocols(protocols);
        return this;
    }

    @Override
    public HttpServerBuilder sslConfig(ServerSslConfig config) {
        this.delegate = this.delegate.sslConfig(config);
        return this;
    }

    @Override
    public HttpServerBuilder sslConfig(ServerSslConfig defaultConfig, Map<String, ServerSslConfig> sniMap) {
        this.delegate = this.delegate.sslConfig(defaultConfig, sniMap);
        return this;
    }

    @Override
    public <T> HttpServerBuilder socketOption(SocketOption<T> option, T value) {
        this.delegate = this.delegate.socketOption(option, value);
        return this;
    }

    @Override
    public <T> HttpServerBuilder listenSocketOption(SocketOption<T> option, T value) {
        this.delegate = this.delegate.listenSocketOption(option, value);
        return this;
    }

    @Override
    public HttpServerBuilder enableWireLogging(String loggerName, LogLevel logLevel, BooleanSupplier logUserData) {
        this.delegate = this.delegate.enableWireLogging(loggerName, logLevel, logUserData);
        return this;
    }

    @Override
    public HttpServerBuilder transportObserver(TransportObserver transportObserver) {
        this.delegate = this.delegate.transportObserver(transportObserver);
        return this;
    }

    @Override
    public HttpServerBuilder lifecycleObserver(HttpLifecycleObserver lifecycleObserver) {
        this.delegate = this.delegate.lifecycleObserver(lifecycleObserver);
        return this;
    }

    @Override
    public HttpServerBuilder drainRequestPayloadBody(boolean enable) {
        this.delegate = this.delegate.drainRequestPayloadBody(enable);
        return this;
    }

    @Override
    public HttpServerBuilder allowDropRequestTrailers(boolean allowDrop) {
        this.delegate = this.delegate.allowDropRequestTrailers(allowDrop);
        return this;
    }

    @Override
    public HttpServerBuilder appendConnectionAcceptorFilter(ConnectionAcceptorFactory factory) {
        this.delegate = this.delegate.appendConnectionAcceptorFilter(factory);
        return this;
    }

    @Override
    public HttpServerBuilder appendNonOffloadingServiceFilter(StreamingHttpServiceFilterFactory factory) {
        this.delegate = this.delegate.appendNonOffloadingServiceFilter(factory);
        return this;
    }

    @Override
    public HttpServerBuilder appendNonOffloadingServiceFilter(Predicate<StreamingHttpRequest> predicate, StreamingHttpServiceFilterFactory factory) {
        this.delegate = this.delegate.appendNonOffloadingServiceFilter(predicate, factory);
        return this;
    }

    @Override
    public HttpServerBuilder appendServiceFilter(StreamingHttpServiceFilterFactory factory) {
        this.delegate = this.delegate.appendServiceFilter(factory);
        return this;
    }

    @Override
    public HttpServerBuilder appendServiceFilter(Predicate<StreamingHttpRequest> predicate, StreamingHttpServiceFilterFactory factory) {
        this.delegate = this.delegate.appendServiceFilter(predicate, factory);
        return this;
    }

    @Override
    public HttpServerBuilder ioExecutor(IoExecutor ioExecutor) {
        this.delegate = this.delegate.ioExecutor(ioExecutor);
        return this;
    }

    @Override
    public HttpServerBuilder executor(Executor executor) {
        this.delegate = this.delegate.executor(executor);
        return this;
    }

    @Override
    public HttpServerBuilder bufferAllocator(BufferAllocator allocator) {
        this.delegate = this.delegate.bufferAllocator(allocator);
        return this;
    }

    @Override
    public HttpServerBuilder executionStrategy(HttpExecutionStrategy strategy) {
        this.delegate = this.delegate.executionStrategy(strategy);
        return this;
    }

    @Override
    public Single<HttpServerContext> listen(HttpService service) {
        return this.delegate.listen(service);
    }

    @Override
    public Single<HttpServerContext> listenStreaming(StreamingHttpService service) {
        return this.delegate.listenStreaming(service);
    }

    @Override
    public Single<HttpServerContext> listenBlocking(BlockingHttpService service) {
        return this.delegate.listenBlocking(service);
    }

    @Override
    public Single<HttpServerContext> listenBlockingStreaming(BlockingStreamingHttpService service) {
        return this.delegate.listenBlockingStreaming(service);
    }

    @Override
    public HttpServerContext listenAndAwait(HttpService service) throws Exception {
        return this.delegate.listenAndAwait(service);
    }

    @Override
    public HttpServerContext listenStreamingAndAwait(StreamingHttpService service) throws Exception {
        return this.delegate.listenStreamingAndAwait(service);
    }

    @Override
    public HttpServerContext listenBlockingAndAwait(BlockingHttpService service) throws Exception {
        return this.delegate.listenBlockingAndAwait(service);
    }

    @Override
    public HttpServerContext listenBlockingStreamingAndAwait(BlockingStreamingHttpService service) throws Exception {
        return this.delegate.listenBlockingStreamingAndAwait(service);
    }
}

