/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.server;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.baremaps.server.DevResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryWatcher
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(DevResources.class);
    private final Set<Path> directories;
    private final Consumer<Path> consumer;

    public DirectoryWatcher(Set<Path> directories, Consumer<Path> consumer) {
        this.directories = directories;
        this.consumer = consumer;
    }

    @Override
    public void run() {
        try (WatchService watchService = FileSystems.getDefault().newWatchService();){
            WatchKey key;
            for (Path directory : this.directories) {
                directory.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
            }
            while ((key = watchService.take()) != null) {
                Path dir = (Path)key.watchable();
                for (WatchEvent<?> event : key.pollEvents()) {
                    Path path = dir.resolve((Path)event.context()).toAbsolutePath();
                    logger.info("Change detected in {}", (Object)path);
                    this.consumer.accept(path);
                }
                key.reset();
            }
        }
        catch (IOException | InterruptedException e) {
            logger.error(e.getMessage());
            Thread.currentThread().interrupt();
        }
    }
}

