/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api.internal;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.internal.ConnectablePayloadWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;

public final class ConnectableBufferOutputStream
extends OutputStream {
    private final ConnectablePayloadWriter<Buffer> payloadWriter = new ConnectablePayloadWriter();
    private final BufferAllocator allocator;

    public ConnectableBufferOutputStream(BufferAllocator allocator) {
        this.allocator = Objects.requireNonNull(allocator);
    }

    @Override
    public void write(int b) throws IOException {
        this.payloadWriter.write(this.allocator.newBuffer(1).writeByte(b));
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.payloadWriter.write(this.allocator.wrap(b));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        this.payloadWriter.write(this.allocator.wrap(b, off, len));
    }

    @Override
    public void flush() throws IOException {
        this.payloadWriter.flush();
    }

    @Override
    public void close() throws IOException {
        this.payloadWriter.close();
    }

    public Publisher<Buffer> connect() {
        return this.payloadWriter.connect();
    }
}

