/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.qualifier;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import org.jdbi.v3.core.generic.GenericType;
import org.jdbi.v3.core.internal.AnnotationFactory;
import org.jdbi.v3.core.internal.CollectionCollectors;

public final class QualifiedType<T> {
    private final Type type;
    private final Set<Annotation> qualifiers;
    private int hashCode;

    public static <T> QualifiedType<T> of(Class<T> clazz) {
        return new QualifiedType<T>(clazz, Collections.emptySet());
    }

    public static QualifiedType<?> of(Type type) {
        return new QualifiedType(type, Collections.emptySet());
    }

    public static <T> QualifiedType<T> of(GenericType<T> type) {
        return QualifiedType.of(type.getType());
    }

    private QualifiedType(Type type, Set<Annotation> qualifiers) {
        this.type = type;
        this.qualifiers = qualifiers;
    }

    public QualifiedType<T> with(Annotation ... newQualifiers) {
        return new QualifiedType<T>(this.type, Arrays.stream(newQualifiers).collect(CollectionCollectors.toUnmodifiableSet()));
    }

    @SafeVarargs
    public final QualifiedType<T> with(Class<? extends Annotation> ... newQualifiers) {
        Set<Annotation> annotations = Arrays.stream(newQualifiers).map(AnnotationFactory::create).collect(CollectionCollectors.toUnmodifiableSet());
        return new QualifiedType<T>(this.type, annotations);
    }

    public QualifiedType<T> withAnnotations(Iterable<? extends Annotation> newQualifiers) {
        return new QualifiedType<T>(this.type, StreamSupport.stream(newQualifiers.spliterator(), false).collect(CollectionCollectors.toUnmodifiableSet()));
    }

    public QualifiedType<T> withAnnotationClasses(Iterable<Class<? extends Annotation>> newQualifiers) {
        Set<Annotation> annotations = StreamSupport.stream(newQualifiers.spliterator(), false).map(AnnotationFactory::create).collect(CollectionCollectors.toUnmodifiableSet());
        return new QualifiedType<T>(this.type, annotations);
    }

    public Type getType() {
        return this.type;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public QualifiedType<?> mapType(Function<Type, Type> mapper) {
        return new QualifiedType<T>(mapper.apply(this.type), this.qualifiers);
    }

    public Optional<QualifiedType<?>> flatMapType(Function<Type, Optional<Type>> mapper) {
        return mapper.apply(this.type).map(mappedType -> new QualifiedType<T>((Type)mappedType, this.qualifiers));
    }

    public boolean hasQualifier(Class<? extends Annotation> qualifier) {
        return this.qualifiers.stream().anyMatch(qualifier::isInstance);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualifiedType that = (QualifiedType)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.qualifiers, that.qualifiers);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = Objects.hash(this.type, this.qualifiers);
        }
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.qualifiers.forEach(qualifier -> builder.append(qualifier).append(' '));
        builder.append(this.type.getTypeName());
        return builder.toString();
    }
}

