/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import org.jdbi.v3.core.mapper.JoinRow;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class JoinRowMapper
implements RowMapper<JoinRow> {
    private final Type[] types;

    private JoinRowMapper(Type[] types) {
        this.types = Arrays.copyOf(types, types.length);
    }

    @Override
    public JoinRow map(ResultSet r, StatementContext ctx) throws SQLException {
        return this.specialize(r, ctx).map(r, ctx);
    }

    @Override
    public RowMapper<JoinRow> specialize(ResultSet r, StatementContext ctx) throws SQLException {
        RowMapper[] mappers = new RowMapper[this.types.length];
        for (int i = 0; i < this.types.length; ++i) {
            Type type = this.types[i];
            mappers[i] = ctx.findRowMapperFor(type).orElseThrow(() -> new IllegalArgumentException("No row mapper registered for " + type)).specialize(r, ctx);
        }
        return (rs, context) -> {
            HashMap<Type, Object> entries = new HashMap<Type, Object>(this.types.length);
            for (int i = 0; i < this.types.length; ++i) {
                Type type = this.types[i];
                RowMapper mapper = mappers[i];
                entries.put(type, mapper.map(r, ctx));
            }
            return new JoinRow(entries);
        };
    }

    public static JoinRowMapper forTypes(Type ... classes) {
        return new JoinRowMapper(classes);
    }
}

