/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.argument;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.argument.BoxedArgumentFactory;
import org.jdbi.v3.core.argument.EnumArgumentFactory;
import org.jdbi.v3.core.argument.EssentialsArgumentFactory;
import org.jdbi.v3.core.argument.InternetArgumentFactory;
import org.jdbi.v3.core.argument.JavaTimeArgumentFactory;
import org.jdbi.v3.core.argument.OptionalArgumentFactory;
import org.jdbi.v3.core.argument.PrimitivesArgumentFactory;
import org.jdbi.v3.core.argument.SqlArgumentFactory;
import org.jdbi.v3.core.argument.SqlTimeArgumentFactory;
import org.jdbi.v3.core.argument.UntypedNullArgumentFactory;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.enums.EnumByName;
import org.jdbi.v3.core.internal.JdbiOptionals;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;

@Deprecated
public class BuiltInArgumentFactory
implements ArgumentFactory.Preparable {
    public static final ArgumentFactory INSTANCE = new BuiltInArgumentFactory();
    private static final List<ArgumentFactory.Preparable> FACTORIES = Arrays.asList(new PrimitivesArgumentFactory(), new BoxedArgumentFactory(), new EssentialsArgumentFactory(), new SqlArgumentFactory(), new InternetArgumentFactory(), new SqlTimeArgumentFactory(), new JavaTimeArgumentFactory(), new LegacyEnumByNameArgumentFactory(), new OptionalArgumentFactory(), new UntypedNullArgumentFactory());

    @Override
    public Optional<Function<Object, Argument>> prepare(Type type, ConfigRegistry config) {
        return FACTORIES.stream().flatMap(factory -> JdbiOptionals.stream(factory.prepare(type, config))).findFirst();
    }

    @Override
    public Optional<Argument> build(Type expectedType, Object value, ConfigRegistry config) {
        return FACTORIES.stream().flatMap(factory -> JdbiOptionals.stream(factory.build(expectedType, value, config))).findFirst();
    }

    @Override
    public Collection<? extends Type> prePreparedTypes() {
        return FACTORIES.stream().map(ArgumentFactory.Preparable::prePreparedTypes).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static class LegacyEnumByNameArgumentFactory
    implements ArgumentFactory.Preparable {
        private final EnumArgumentFactory delegate = new EnumArgumentFactory();

        private LegacyEnumByNameArgumentFactory() {
        }

        @Override
        public Optional<Function<Object, Argument>> prepare(Type type, ConfigRegistry config) {
            return EnumArgumentFactory.ifEnum(type).map(clazz -> value -> this.build(type, value, config).orElseThrow(() -> new UnableToCreateStatementException("No enum value to bind after prepare")));
        }

        @Override
        public Optional<Argument> build(Type expectedType, Object rawValue, ConfigRegistry config) {
            return this.delegate.build(QualifiedType.of(expectedType).with(EnumByName.class), rawValue, config);
        }
    }
}

