/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.features.user;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import mil.nga.geopackage.features.user.FeatureRow;

public class FeatureCache {
    public static final int DEFAULT_CACHE_MAX_SIZE = 1000;
    private final Map<Long, FeatureRow> cache;
    private int maxSize;

    public FeatureCache() {
        this(1000);
    }

    public FeatureCache(int size) {
        this.maxSize = size;
        this.cache = new LinkedHashMap<Long, FeatureRow>(this.maxSize, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<Long, FeatureRow> eldest) {
                return this.size() > FeatureCache.this.maxSize;
            }
        };
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getSize() {
        return this.cache.size();
    }

    public FeatureRow get(long featureId) {
        return this.cache.get(featureId);
    }

    public FeatureRow put(FeatureRow featureRow) {
        return this.cache.put(featureRow.getId(), featureRow);
    }

    public FeatureRow remove(FeatureRow featureRow) {
        return this.remove(featureRow.getId());
    }

    public FeatureRow remove(long featureId) {
        return this.cache.remove(featureId);
    }

    public void clear() {
        this.cache.clear();
    }

    public void resize(int maxSize) {
        this.maxSize = maxSize;
        if (this.cache.size() > maxSize) {
            int count = 0;
            Iterator<Long> rowIds = this.cache.keySet().iterator();
            while (rowIds.hasNext()) {
                rowIds.next();
                if (++count <= maxSize) continue;
                rowIds.remove();
            }
        }
    }

    public void clearAndResize(int maxSize) {
        this.clear();
        this.resize(maxSize);
    }
}

