/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.coverage;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.TreeMap;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.extension.coverage.CoverageDataCore;
import mil.nga.geopackage.extension.coverage.CoverageDataImage;
import mil.nga.geopackage.extension.coverage.CoverageDataPng;
import mil.nga.geopackage.extension.coverage.CoverageDataRequest;
import mil.nga.geopackage.extension.coverage.CoverageDataResults;
import mil.nga.geopackage.extension.coverage.CoverageDataTiff;
import mil.nga.geopackage.extension.coverage.CoverageDataTileMatrixResults;
import mil.nga.geopackage.extension.coverage.GriddedCoverage;
import mil.nga.geopackage.extension.coverage.GriddedCoverageDao;
import mil.nga.geopackage.extension.coverage.GriddedCoverageDataType;
import mil.nga.geopackage.extension.coverage.GriddedTile;
import mil.nga.geopackage.tiles.ImageRectangle;
import mil.nga.geopackage.tiles.ImageRectangleF;
import mil.nga.geopackage.tiles.TileBoundingBoxJavaUtils;
import mil.nga.geopackage.tiles.TileBoundingBoxUtils;
import mil.nga.geopackage.tiles.TileGrid;
import mil.nga.geopackage.tiles.matrix.TileMatrix;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSet;
import mil.nga.geopackage.tiles.user.TileDao;
import mil.nga.geopackage.tiles.user.TileResultSet;
import mil.nga.geopackage.tiles.user.TileRow;
import mil.nga.geopackage.tiles.user.TileTable;
import mil.nga.geopackage.tiles.user.TileTableMetadata;
import mil.nga.proj.Projection;
import mil.nga.proj.ProjectionTransform;
import mil.nga.sf.proj.GeometryTransform;

public abstract class CoverageData<TImage extends CoverageDataImage>
extends CoverageDataCore<TImage> {
    protected final TileDao tileDao;

    public static CoverageData<?> getCoverageData(GeoPackage geoPackage, TileDao tileDao, Integer width, Integer height, Projection requestProjection) {
        TileMatrixSet tileMatrixSet = tileDao.getTileMatrixSet();
        GriddedCoverageDao griddedCoverageDao = CoverageData.getGriddedCoverageDao((GeoPackageCore)geoPackage);
        GriddedCoverage griddedCoverage = null;
        try {
            if (griddedCoverageDao.isTableExists()) {
                griddedCoverage = griddedCoverageDao.query(tileMatrixSet);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to get Gridded Coverage for table name: " + tileMatrixSet.getTableName(), (Throwable)e);
        }
        CoverageData coverageData = null;
        GriddedCoverageDataType dataType = griddedCoverage.getDataType();
        switch (dataType) {
            case INTEGER: {
                coverageData = new CoverageDataPng(geoPackage, tileDao, width, height, requestProjection);
                break;
            }
            case FLOAT: {
                coverageData = new CoverageDataTiff(geoPackage, tileDao, width, height, requestProjection);
                break;
            }
            default: {
                throw new GeoPackageException("Unsupported Gridded Coverage Data Type: " + dataType);
            }
        }
        return coverageData;
    }

    public static CoverageData<?> getCoverageData(GeoPackage geoPackage, TileDao tileDao) {
        return CoverageData.getCoverageData(geoPackage, tileDao, null, null, tileDao.getProjection());
    }

    public static CoverageData<?> getCoverageData(GeoPackage geoPackage, TileDao tileDao, Projection requestProjection) {
        return CoverageData.getCoverageData(geoPackage, tileDao, null, null, requestProjection);
    }

    public static CoverageData<?> createTileTable(GeoPackage geoPackage, TileTableMetadata metadata, GriddedCoverageDataType dataType) {
        TileTable tileTable = CoverageDataCore.createTileTable((GeoPackageCore)geoPackage, (TileTableMetadata)metadata);
        TileDao tileDao = geoPackage.getTileDao(tileTable);
        CoverageData coverageData = null;
        switch (dataType) {
            case INTEGER: {
                coverageData = new CoverageDataPng(geoPackage, tileDao);
                break;
            }
            case FLOAT: {
                coverageData = new CoverageDataTiff(geoPackage, tileDao);
                break;
            }
            default: {
                throw new GeoPackageException("Unsupported Gridded Coverage Data Type: " + dataType);
            }
        }
        coverageData.getOrCreate();
        return coverageData;
    }

    public CoverageData(GeoPackage geoPackage, TileDao tileDao, Integer width, Integer height, Projection requestProjection) {
        super((GeoPackageCore)geoPackage, tileDao.getTileMatrixSet(), width, height, requestProjection);
        this.tileDao = tileDao;
    }

    public abstract TImage createImage(TileRow var1);

    public abstract double getValue(GriddedTile var1, TileRow var2, int var3, int var4);

    public abstract Double getValue(GriddedTile var1, byte[] var2, int var3, int var4);

    public abstract Double[] getValues(GriddedTile var1, byte[] var2);

    public abstract byte[] drawTileData(GriddedTile var1, Double[] var2, int var3, int var4);

    public abstract byte[] drawTileData(GriddedTile var1, Double[][] var2);

    public TileDao getTileDao() {
        return this.tileDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoverageDataResults getValues(CoverageDataRequest request, Integer width, Integer height) {
        int overlappingPixels;
        CoverageDataResults coverageDataResults = null;
        GeometryTransform transformRequestToCoverage = null;
        BoundingBox requestProjectedBoundingBox = request.getBoundingBox();
        if (!this.sameProjection) {
            transformRequestToCoverage = GeometryTransform.create((Projection)this.requestProjection, (Projection)this.coverageProjection);
            requestProjectedBoundingBox = requestProjectedBoundingBox.transform(transformRequestToCoverage);
        }
        request.setProjectedBoundingBox(requestProjectedBoundingBox);
        switch (this.algorithm) {
            case BICUBIC: {
                overlappingPixels = 3;
                break;
            }
            default: {
                overlappingPixels = 1;
            }
        }
        CoverageDataTileMatrixResults results = this.getResults(request, requestProjectedBoundingBox, overlappingPixels);
        if (results != null) {
            TileMatrix tileMatrix = results.getTileMatrix();
            try (TileResultSet tileResults = results.getTileResults();){
                Double[][] values;
                int requestedCoverageDataWidth = width != null ? width : (int)tileMatrix.getTileWidth();
                int requestedCoverageDataHeight = height != null ? height : (int)tileMatrix.getTileHeight();
                int tileWidth = requestedCoverageDataWidth;
                int tileHeight = requestedCoverageDataHeight;
                if (!this.sameProjection) {
                    int projectedHeight;
                    int projectedWidth = (int)Math.round((requestProjectedBoundingBox.getMaxLongitude() - requestProjectedBoundingBox.getMinLongitude()) / tileMatrix.getPixelXSize());
                    if (projectedWidth > 0) {
                        tileWidth = projectedWidth;
                    }
                    if ((projectedHeight = (int)Math.round((requestProjectedBoundingBox.getMaxLatitude() - requestProjectedBoundingBox.getMinLatitude()) / tileMatrix.getPixelYSize())) > 0) {
                        tileHeight = projectedHeight;
                    }
                }
                if ((values = this.getValues(tileMatrix, tileResults, request, tileWidth, tileHeight, overlappingPixels)) != null && !this.sameProjection && !request.isPoint()) {
                    values = this.reprojectCoverageData(values, requestedCoverageDataWidth, requestedCoverageDataHeight, request.getBoundingBox(), (ProjectionTransform)transformRequestToCoverage, requestProjectedBoundingBox);
                }
                if (values != null) {
                    coverageDataResults = new CoverageDataResults(values, tileMatrix);
                }
            }
        }
        return coverageDataResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoverageDataResults getValuesUnbounded(CoverageDataRequest request) {
        CoverageDataResults coverageDataResults = null;
        GeometryTransform transformRequestToCoverage = null;
        BoundingBox requestProjectedBoundingBox = request.getBoundingBox();
        if (!this.sameProjection) {
            transformRequestToCoverage = GeometryTransform.create((Projection)this.requestProjection, (Projection)this.coverageProjection);
            requestProjectedBoundingBox = requestProjectedBoundingBox.transform(transformRequestToCoverage);
        }
        request.setProjectedBoundingBox(requestProjectedBoundingBox);
        CoverageDataTileMatrixResults results = this.getResults(request, requestProjectedBoundingBox);
        if (results != null) {
            TileMatrix tileMatrix = results.getTileMatrix();
            try (TileResultSet tileResults = results.getTileResults();){
                Double[][] values = this.getValuesUnbounded(tileMatrix, tileResults, request);
                if (values != null && !this.sameProjection && !request.isPoint()) {
                    values = this.reprojectCoverageData(values, values[0].length, values.length, request.getBoundingBox(), (ProjectionTransform)transformRequestToCoverage, requestProjectedBoundingBox);
                }
                if (values != null) {
                    coverageDataResults = new CoverageDataResults(values, tileMatrix);
                }
            }
        }
        return coverageDataResults;
    }

    private CoverageDataTileMatrixResults getResults(CoverageDataRequest request, BoundingBox requestProjectedBoundingBox) {
        return this.getResults(request, requestProjectedBoundingBox, 0);
    }

    private CoverageDataTileMatrixResults getResults(CoverageDataRequest request, BoundingBox requestProjectedBoundingBox, int overlappingPixels) {
        TileMatrix tileMatrix = this.getTileMatrix(request);
        CoverageDataTileMatrixResults results = null;
        if (tileMatrix != null && (results = this.getResults(requestProjectedBoundingBox, tileMatrix, overlappingPixels)) == null) {
            results = this.getResultsZoom(requestProjectedBoundingBox, tileMatrix, overlappingPixels);
        }
        return results;
    }

    private CoverageDataTileMatrixResults getResults(BoundingBox requestProjectedBoundingBox, TileMatrix tileMatrix, int overlappingPixels) {
        CoverageDataTileMatrixResults results = null;
        BoundingBox paddedBoundingBox = this.padBoundingBox(tileMatrix, requestProjectedBoundingBox, overlappingPixels);
        TileResultSet tileResults = this.retrieveSortedTileResults(paddedBoundingBox, tileMatrix);
        if (tileResults != null) {
            if (tileResults.getCount() > 0) {
                results = new CoverageDataTileMatrixResults(tileMatrix, tileResults);
            } else {
                tileResults.close();
            }
        }
        return results;
    }

    private CoverageDataTileMatrixResults getResultsZoom(BoundingBox requestProjectedBoundingBox, TileMatrix tileMatrix, int overlappingPixels) {
        CoverageDataTileMatrixResults results = null;
        if (this.zoomIn && this.zoomInBeforeOut) {
            results = this.getResultsZoomIn(requestProjectedBoundingBox, tileMatrix, overlappingPixels);
        }
        if (results == null && this.zoomOut) {
            results = this.getResultsZoomOut(requestProjectedBoundingBox, tileMatrix, overlappingPixels);
        }
        if (results == null && this.zoomIn && !this.zoomInBeforeOut) {
            results = this.getResultsZoomIn(requestProjectedBoundingBox, tileMatrix, overlappingPixels);
        }
        return results;
    }

    private CoverageDataTileMatrixResults getResultsZoomIn(BoundingBox requestProjectedBoundingBox, TileMatrix tileMatrix, int overlappingPixels) {
        TileMatrix zoomTileMatrix;
        CoverageDataTileMatrixResults results = null;
        for (long zoomLevel = tileMatrix.getZoomLevel() + 1L; zoomLevel <= this.tileDao.getMaxZoom() && ((zoomTileMatrix = this.tileDao.getTileMatrix(zoomLevel)) == null || (results = this.getResults(requestProjectedBoundingBox, zoomTileMatrix, overlappingPixels)) == null); ++zoomLevel) {
        }
        return results;
    }

    private CoverageDataTileMatrixResults getResultsZoomOut(BoundingBox requestProjectedBoundingBox, TileMatrix tileMatrix, int overlappingPixels) {
        TileMatrix zoomTileMatrix;
        CoverageDataTileMatrixResults results = null;
        for (long zoomLevel = tileMatrix.getZoomLevel() - 1L; zoomLevel >= this.tileDao.getMinZoom() && ((zoomTileMatrix = this.tileDao.getTileMatrix(zoomLevel)) == null || (results = this.getResults(requestProjectedBoundingBox, zoomTileMatrix, overlappingPixels)) == null); --zoomLevel) {
        }
        return results;
    }

    private Double[][] getValues(TileMatrix tileMatrix, TileResultSet tileResults, CoverageDataRequest request, int tileWidth, int tileHeight, int overlappingPixels) {
        Double[][] values = null;
        Double[][] leftLastColumns = null;
        HashMap<Long, Double[][]> lastRowsByColumn = null;
        HashMap<Long, Double[][]> previousLastRowsByColumn = null;
        long previousRow = -1L;
        long previousColumn = Long.MAX_VALUE;
        while (tileResults.moveToNext()) {
            TileRow tileRow = (TileRow)tileResults.getRow();
            long currentRow = tileRow.getTileRow();
            long currentColumn = tileRow.getTileColumn();
            if (currentRow > previousRow) {
                previousLastRowsByColumn = lastRowsByColumn;
                lastRowsByColumn = new HashMap<Long, Double[][]>();
                leftLastColumns = null;
            }
            Double[][] topLeftRows = null;
            Double[][] topRows = null;
            if (previousLastRowsByColumn != null) {
                topLeftRows = (Double[][])previousLastRowsByColumn.get(currentColumn - 1L);
                topRows = (Double[][])previousLastRowsByColumn.get(currentColumn);
            }
            if (currentColumn < previousColumn || currentColumn != previousColumn + 1L) {
                leftLastColumns = null;
            }
            BoundingBox tileBoundingBox = TileBoundingBoxUtils.getBoundingBox((BoundingBox)this.coverageBoundingBox, (TileMatrix)tileMatrix, (long)currentColumn, (long)currentRow);
            BoundingBox overlap = request.overlap(tileBoundingBox);
            GriddedTile griddedTile = this.getGriddedTile(tileRow.getId());
            TImage image = this.createImage(tileRow);
            if (overlap != null) {
                ImageRectangleF src = TileBoundingBoxJavaUtils.getFloatRectangle(tileMatrix.getTileWidth(), tileMatrix.getTileHeight(), tileBoundingBox, overlap);
                ImageRectangleF dest = null;
                dest = request.getProjectedBoundingBox().equals((Object)overlap) ? (request.isPoint() ? new ImageRectangleF(0.0f, 0.0f, 0.0f, 0.0f) : new ImageRectangleF(0.0f, 0.0f, tileWidth, tileHeight)) : TileBoundingBoxJavaUtils.getFloatRectangle(tileWidth, tileHeight, request.getProjectedBoundingBox(), overlap);
                if (src.isValidAllowEmpty() && dest.isValidAllowEmpty()) {
                    float halfDestHeightPixel;
                    float heightRatio;
                    float halfDestWidthPixel;
                    float widthRatio;
                    if (values == null) {
                        values = new Double[tileHeight][tileWidth];
                    }
                    float destWidth = dest.getRight() - dest.getLeft();
                    float destHeight = dest.getBottom() - dest.getTop();
                    float srcWidth = src.getRight() - src.getLeft();
                    float srcHeight = src.getBottom() - src.getTop();
                    if (destWidth == 0.0f) {
                        widthRatio = 0.0f;
                        halfDestWidthPixel = 0.0f;
                    } else {
                        widthRatio = srcWidth / destWidth;
                        halfDestWidthPixel = 0.5f / widthRatio;
                    }
                    if (destHeight == 0.0f) {
                        heightRatio = 0.0f;
                        halfDestHeightPixel = 0.0f;
                    } else {
                        heightRatio = srcHeight / destHeight;
                        halfDestHeightPixel = 0.5f / heightRatio;
                    }
                    float algorithmDestWidthPixelOverlap = halfDestWidthPixel * (float)overlappingPixels;
                    float algorithmDestHeightPixelOverlap = halfDestHeightPixel * (float)overlappingPixels;
                    int minDestY = (int)Math.floor(dest.getTop() - algorithmDestHeightPixelOverlap);
                    int maxDestY = (int)Math.ceil(dest.getBottom() + algorithmDestHeightPixelOverlap);
                    int minDestX = (int)Math.floor(dest.getLeft() - algorithmDestWidthPixelOverlap);
                    int maxDestX = (int)Math.ceil(dest.getRight() + algorithmDestWidthPixelOverlap);
                    minDestY = Math.max(minDestY, 0);
                    minDestX = Math.max(minDestX, 0);
                    maxDestY = Math.min(maxDestY, tileHeight - 1);
                    maxDestX = Math.min(maxDestX, tileWidth - 1);
                    for (int y = minDestY; y <= maxDestY; ++y) {
                        for (int x = minDestX; x <= maxDestX; ++x) {
                            if (values[y][x] != null) continue;
                            Double value = null;
                            switch (this.algorithm) {
                                case NEAREST_NEIGHBOR: {
                                    value = this.getNearestNeighborValue(griddedTile, (CoverageDataImage)image, leftLastColumns, topLeftRows, topRows, y, x, widthRatio, heightRatio, dest.getTop(), dest.getLeft(), src.getTop(), src.getLeft());
                                    break;
                                }
                                case BILINEAR: {
                                    value = this.getBilinearInterpolationValue(griddedTile, (CoverageDataImage)image, leftLastColumns, topLeftRows, topRows, y, x, widthRatio, heightRatio, dest.getTop(), dest.getLeft(), src.getTop(), src.getLeft());
                                    break;
                                }
                                case BICUBIC: {
                                    value = this.getBicubicInterpolationValue(griddedTile, (CoverageDataImage)image, leftLastColumns, topLeftRows, topRows, y, x, widthRatio, heightRatio, dest.getTop(), dest.getLeft(), src.getTop(), src.getLeft());
                                    break;
                                }
                                default: {
                                    throw new UnsupportedOperationException("Algorithm is not supported: " + this.algorithm);
                                }
                            }
                            if (value == null) continue;
                            values[y][x] = value;
                        }
                    }
                }
            }
            leftLastColumns = new Double[overlappingPixels][(int)tileMatrix.getTileHeight()];
            Double[][] lastRows = new Double[overlappingPixels][(int)tileMatrix.getTileWidth()];
            lastRowsByColumn.put(currentColumn, lastRows);
            for (int lastIndex = 0; lastIndex < overlappingPixels; ++lastIndex) {
                int lastColumnIndex = (int)tileMatrix.getTileWidth() - lastIndex - 1;
                int row = 0;
                while ((long)row < tileMatrix.getTileHeight()) {
                    Double value;
                    leftLastColumns[lastIndex][row] = value = this.getValue(griddedTile, (CoverageDataImage)image, lastColumnIndex, row);
                    ++row;
                }
                int lastRowIndex = (int)tileMatrix.getTileHeight() - lastIndex - 1;
                int column = 0;
                while ((long)column < tileMatrix.getTileWidth()) {
                    Double value;
                    lastRows[lastIndex][column] = value = this.getValue(griddedTile, (CoverageDataImage)image, column, lastRowIndex);
                    ++column;
                }
            }
            previousRow = currentRow;
            previousColumn = currentColumn;
        }
        return values;
    }

    private Double[][] getValuesUnbounded(TileMatrix tileMatrix, TileResultSet tileResults, CoverageDataRequest request) {
        TreeMap rowsMap = new TreeMap();
        Long minRow = null;
        Long maxRow = null;
        Long minColumn = null;
        Long maxColumn = null;
        int tileCount = 0;
        while (tileResults.moveToNext()) {
            ImageRectangle src;
            TileRow tileRow = (TileRow)tileResults.getRow();
            BoundingBox tileBoundingBox = TileBoundingBoxUtils.getBoundingBox((BoundingBox)this.coverageBoundingBox, (TileMatrix)tileMatrix, (long)tileRow.getTileColumn(), (long)tileRow.getTileRow());
            BoundingBox overlap = request.overlap(tileBoundingBox);
            if (overlap == null || !(src = TileBoundingBoxJavaUtils.getRectangle(tileMatrix.getTileWidth(), tileMatrix.getTileHeight(), tileBoundingBox, overlap)).isValidAllowEmpty()) continue;
            int srcTop = Math.min(src.getTop(), (int)tileMatrix.getTileHeight() - 1);
            int srcBottom = Math.min(src.getBottom(), (int)tileMatrix.getTileHeight() - 1);
            int srcLeft = Math.min(src.getLeft(), (int)tileMatrix.getTileWidth() - 1);
            int srcRight = Math.min(src.getRight(), (int)tileMatrix.getTileWidth() - 1);
            GriddedTile griddedTile = this.getGriddedTile(tileRow.getId());
            TImage image = this.createImage(tileRow);
            Double[][] values = new Double[srcBottom - srcTop + 1][srcRight - srcLeft + 1];
            TreeMap<Long, Double[][]> columnsMap = (TreeMap<Long, Double[][]>)rowsMap.get(tileRow.getTileRow());
            if (columnsMap == null) {
                columnsMap = new TreeMap<Long, Double[][]>();
                rowsMap.put(tileRow.getTileRow(), columnsMap);
            }
            for (int y = srcTop; y <= srcBottom; ++y) {
                for (int x = srcLeft; x <= srcRight; ++x) {
                    Double value;
                    values[y - srcTop][x - srcLeft] = value = this.getValue(griddedTile, (CoverageDataImage)image, x, y);
                }
            }
            columnsMap.put(tileRow.getTileColumn(), values);
            ++tileCount;
            minRow = minRow == null ? tileRow.getTileRow() : Math.min(minRow, tileRow.getTileRow());
            maxRow = maxRow == null ? tileRow.getTileRow() : Math.max(maxRow, tileRow.getTileRow());
            minColumn = minColumn == null ? tileRow.getTileColumn() : Math.min(minColumn, tileRow.getTileColumn());
            maxColumn = maxColumn == null ? tileRow.getTileColumn() : Math.max(maxColumn, tileRow.getTileColumn());
        }
        Double[][] values = this.formatUnboundedResults(tileMatrix, rowsMap, tileCount, minRow, maxRow, minColumn, maxColumn);
        return values;
    }

    private TileMatrix getTileMatrix(CoverageDataRequest request) {
        double distanceHeight;
        BoundingBox projectedBoundingBox;
        double distanceWidth;
        Long zoomLevel;
        TileMatrix tileMatrix = null;
        if (request.overlap(this.coverageBoundingBox) != null && (zoomLevel = this.tileDao.getClosestZoomLevel(distanceWidth = (projectedBoundingBox = request.getProjectedBoundingBox()).getMaxLongitude() - projectedBoundingBox.getMinLongitude(), distanceHeight = projectedBoundingBox.getMaxLatitude() - projectedBoundingBox.getMinLatitude())) != null) {
            tileMatrix = this.tileDao.getTileMatrix(zoomLevel);
        }
        return tileMatrix;
    }

    private TileResultSet retrieveSortedTileResults(BoundingBox projectedRequestBoundingBox, TileMatrix tileMatrix) {
        TileResultSet tileResults = null;
        if (tileMatrix != null) {
            TileGrid tileGrid = TileBoundingBoxUtils.getTileGrid((BoundingBox)this.coverageBoundingBox, (long)tileMatrix.getMatrixWidth(), (long)tileMatrix.getMatrixHeight(), (BoundingBox)projectedRequestBoundingBox);
            tileResults = this.tileDao.queryByTileGrid(tileGrid, tileMatrix.getZoomLevel(), "tile_row,tile_column");
        }
        return tileResults;
    }

    public double getValue(TileRow tileRow, int x, int y) {
        GriddedTile griddedTile = this.getGriddedTile(tileRow.getId());
        double value = this.getValue(griddedTile, tileRow, x, y);
        return value;
    }
}

