/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.http.api.Http2Settings;
import io.servicetalk.http.api.HttpLifecycleObserver;
import io.servicetalk.http.netty.HttpConfig;
import io.servicetalk.http.netty.ReadOnlyHttpServerConfig;
import io.servicetalk.tcp.netty.internal.TcpServerConfig;
import io.servicetalk.transport.api.DelegatingServerSslConfig;
import io.servicetalk.transport.api.ServerSslConfig;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

final class HttpServerConfig {
    private final TcpServerConfig tcpConfig = new TcpServerConfig();
    private final HttpConfig httpConfig = new HttpConfig(h2Config -> {
        Http2Settings settings = h2Config.initialSettings();
        Long pushEnabled = settings.settingValue('\u0002');
        if (pushEnabled != null && pushEnabled != 0L) {
            throw new IllegalArgumentException("Server cannot set SETTINGS_ENABLE_PUSH value other than 0, settings=" + settings);
        }
    });
    @Nullable
    private HttpLifecycleObserver lifecycleObserver;

    HttpServerConfig() {
    }

    TcpServerConfig tcpConfig() {
        return this.tcpConfig;
    }

    HttpConfig httpConfig() {
        return this.httpConfig;
    }

    @Nullable
    HttpLifecycleObserver lifecycleObserver() {
        return this.lifecycleObserver;
    }

    HttpServerConfig lifecycleObserver(HttpLifecycleObserver observer) {
        this.lifecycleObserver = Objects.requireNonNull(observer);
        return this;
    }

    ReadOnlyHttpServerConfig asReadOnly() {
        this.applySslConfigOverrides();
        ReadOnlyHttpServerConfig roConfig = new ReadOnlyHttpServerConfig(this);
        if (roConfig.tcpConfig().sslContext() == null && roConfig.h1Config() != null && roConfig.h2Config() != null) {
            throw new IllegalStateException("Cleartext HTTP/1.1 -> HTTP/2 (h2c) upgrade is not supported");
        }
        return roConfig;
    }

    private void applySslConfigOverrides() {
        Object sslConfig = (ServerSslConfig)this.tcpConfig.sslConfig();
        if (sslConfig != null) {
            sslConfig = new DelegatingHttpServerSslConfig((ServerSslConfig)sslConfig, HttpServerConfig.httpAlpnProtocols(sslConfig.alpnProtocols(), this.httpConfig.supportedAlpnProtocols()));
            Map sniMap = this.tcpConfig.sniConfig();
            if (sniMap == null) {
                this.tcpConfig.sslConfig(sslConfig);
            } else {
                LinkedHashMap sniMapOverrides = new LinkedHashMap(sniMap.size());
                for (Map.Entry sniConfigEntry : sniMap.entrySet()) {
                    ServerSslConfig sniConfig = (ServerSslConfig)sniConfigEntry.getValue();
                    sniMapOverrides.put(sniConfigEntry.getKey(), new DelegatingHttpServerSslConfig(sniConfig, HttpServerConfig.httpAlpnProtocols(sniConfig.alpnProtocols(), this.httpConfig.supportedAlpnProtocols())));
                }
                this.tcpConfig.sslConfig(sslConfig, sniMapOverrides);
            }
        }
    }

    @Nullable
    static List<String> httpAlpnProtocols(@Nullable List<String> sslConfigAlpn, List<String> httpAlpn) {
        return !httpAlpn.isEmpty() ? httpAlpn : null;
    }

    private static final class DelegatingHttpServerSslConfig
    extends DelegatingServerSslConfig {
        @Nullable
        private final List<String> alpnProtocols;

        DelegatingHttpServerSslConfig(ServerSslConfig sslConfig, @Nullable List<String> alpnProtocols) {
            super(sslConfig);
            this.alpnProtocols = alpnProtocols;
        }

        public List<String> alpnProtocols() {
            return this.alpnProtocols;
        }
    }
}

