/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.SniHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.Mapping;
import io.servicetalk.transport.netty.internal.ChannelInitializer;
import io.servicetalk.transport.netty.internal.CopyByteBufHandlerChannelInitializer;
import java.util.Objects;

public final class SniServerChannelInitializer
implements ChannelInitializer {
    private final Mapping<String, SslContext> sniMapping;

    public SniServerChannelInitializer(Mapping<String, SslContext> sniMapping) {
        this.sniMapping = Objects.requireNonNull(sniMapping);
    }

    @Override
    public void init(Channel channel) {
        channel.pipeline().addLast(new ChannelHandler[]{new SniHandlerWithPooledAllocator(this.sniMapping)});
    }

    private static final class SniHandlerWithPooledAllocator
    extends SniHandler {
        SniHandlerWithPooledAllocator(Mapping<String, SslContext> mapping) {
            super(mapping);
        }

        protected SslHandler newSslHandler(SslContext context, ByteBufAllocator ignore) {
            return super.newSslHandler(context, (ByteBufAllocator)CopyByteBufHandlerChannelInitializer.POOLED_ALLOCATOR);
        }
    }
}

