/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.util.concurrent.FastThreadLocalThread;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.transport.api.IoThreadFactory;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

public final class NettyIoThreadFactory
implements IoThreadFactory<NettyIoThread> {
    private static final AtomicInteger factoryCount = new AtomicInteger();
    private final AtomicInteger threadCount = new AtomicInteger();
    private final String namePrefix;
    private final boolean daemon;
    @Nullable
    private final ThreadGroup threadGroup;

    public NettyIoThreadFactory(String threadNamePrefix) {
        this(threadNamePrefix, true);
    }

    public NettyIoThreadFactory(String threadNamePrefix, boolean daemon) {
        this(threadNamePrefix, daemon, System.getSecurityManager() == null ? Thread.currentThread().getThreadGroup() : System.getSecurityManager().getThreadGroup());
    }

    NettyIoThreadFactory(String threadNamePrefix, boolean daemon, @Nullable ThreadGroup threadGroup) {
        this.namePrefix = Objects.requireNonNull(threadNamePrefix) + '-' + factoryCount.incrementAndGet() + '-';
        this.daemon = daemon;
        this.threadGroup = threadGroup;
    }

    public NettyIoThread newThread(Runnable r) {
        NettyIoThread t = new NettyIoThread(this.threadGroup, r, this.namePrefix + this.threadCount.incrementAndGet());
        if (t.isDaemon() != this.daemon) {
            t.setDaemon(this.daemon);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }

    public String toString() {
        return NettyIoThreadFactory.class.getSimpleName() + "{namePrefix='" + this.namePrefix + '\'' + ", daemon=" + this.daemon + ", threadGroup=" + this.threadGroup + ", threadCount=" + this.threadCount + '}';
    }

    static final class NettyIoThread
    extends FastThreadLocalThread
    implements IoThreadFactory.IoThread {
        @Nullable
        private ContextMap context;

        NettyIoThread(@Nullable ThreadGroup group, Runnable target, String name) {
            super(group, target, name);
        }

        @Nullable
        public ContextMap context() {
            return this.context;
        }

        public NettyIoThread context(@Nullable ContextMap context) {
            this.context = context;
            return this;
        }
    }
}

