/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.rocksdb;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;

public class RocksDbStorageUtils {
    public static final ByteOrder KEY_BYTE_ORDER = ByteOrder.BIG_ENDIAN;
    public static final int ROW_ID_SIZE = 16;
    public static final int PARTITION_ID_SIZE = 2;
    public static final int INDEX_ID_SIZE = 4;
    public static final int TABLE_ID_SIZE = 4;

    static void putRowIdUuid(ByteBuffer keyBuffer, UUID rowIdUuid) {
        assert (keyBuffer.order() == KEY_BYTE_ORDER);
        keyBuffer.putLong(RocksDbStorageUtils.normalize(rowIdUuid.getMostSignificantBits()));
        keyBuffer.putLong(RocksDbStorageUtils.normalize(rowIdUuid.getLeastSignificantBits()));
    }

    static UUID getRowIdUuid(ByteBuffer keyBuffer, int offset) {
        return new UUID(RocksDbStorageUtils.normalize(keyBuffer.getLong(offset)), RocksDbStorageUtils.normalize(keyBuffer.getLong(offset + 8)));
    }

    static long normalize(long value) {
        return value ^ Long.MIN_VALUE;
    }

    public static byte[] createKey(byte[] prefix, int ... values) {
        ByteBuffer buf = ByteBuffer.allocate(prefix.length + 4 * values.length).order(KEY_BYTE_ORDER);
        buf.put(prefix);
        for (int value : values) {
            buf.putInt(value);
        }
        return buf.array();
    }
}

