/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.restart;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.restart.IgniteAttachmentLock;
import org.apache.ignite3.internal.wrapper.Wrapper;
import org.apache.ignite3.internal.wrapper.Wrappers;
import org.apache.ignite3.tx.IgniteTransactions;
import org.apache.ignite3.tx.Transaction;
import org.apache.ignite3.tx.TransactionOptions;
import org.jetbrains.annotations.Nullable;

class RestartProofIgniteTransactions
implements IgniteTransactions,
Wrapper {
    private final IgniteAttachmentLock attachmentLock;

    RestartProofIgniteTransactions(IgniteAttachmentLock attachmentLock) {
        this.attachmentLock = attachmentLock;
    }

    @Override
    public Transaction begin(@Nullable TransactionOptions options) {
        return this.attachmentLock.attached(ignite -> ignite.transactions().begin(options));
    }

    @Override
    public CompletableFuture<Transaction> beginAsync(@Nullable TransactionOptions options) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.transactions().beginAsync(options));
    }

    @Override
    public <T> T unwrap(Class<T> classToUnwrap) {
        return (T)this.attachmentLock.attached(ignite -> Wrappers.unwrap(ignite.transactions(), classToUnwrap));
    }
}

