/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.optimizer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.context.DriverContext;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteRequest;
import org.apache.plc4x.java.spi.messages.utils.TagValueItem;
import org.apache.plc4x.java.spi.optimizer.BaseOptimizer;

public class SingleTagOptimizer
extends BaseOptimizer {
    @Override
    protected List<PlcReadRequest> processReadRequest(PlcReadRequest readRequest, DriverContext driverContext) {
        if (readRequest.getNumberOfTags() == 1) {
            return Collections.singletonList(readRequest);
        }
        ArrayList<PlcReadRequest> subRequests = new ArrayList<PlcReadRequest>(readRequest.getNumberOfTags());
        for (String tagName : readRequest.getTagNames()) {
            PlcTag tag = readRequest.getTag(tagName);
            DefaultPlcReadRequest subRequest = new DefaultPlcReadRequest(((DefaultPlcReadRequest)readRequest).getReader(), new LinkedHashMap<String, PlcTag>(Collections.singletonMap(tagName, tag)));
            subRequests.add(subRequest);
        }
        return subRequests;
    }

    @Override
    protected List<PlcWriteRequest> processWriteRequest(PlcWriteRequest writeRequest, DriverContext driverContext) {
        if (writeRequest.getNumberOfTags() == 1) {
            return Collections.singletonList(writeRequest);
        }
        ArrayList<PlcWriteRequest> subRequests = new ArrayList<PlcWriteRequest>(writeRequest.getNumberOfTags());
        for (String tagName : writeRequest.getTagNames()) {
            PlcTag tag = writeRequest.getTag(tagName);
            PlcValue value = writeRequest.getPlcValue(tagName);
            DefaultPlcWriteRequest subRequest = new DefaultPlcWriteRequest(((DefaultPlcWriteRequest)writeRequest).getWriter(), new LinkedHashMap<String, TagValueItem>(Collections.singletonMap(tagName, new TagValueItem(tag, value))));
            subRequests.add(subRequest);
        }
        return subRequests;
    }
}

