/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class ResourceBundleUtf8Control
extends ResourceBundle.Control {
    private static final String JAVA_CLASS = "java.class";
    private static final String JAVA_PROPERTIES = "java.properties";
    private static final String SPILT = "://";

    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        String bundleName = this.toBundleName(baseName, locale);
        ResourceBundle bundle = null;
        if (JAVA_CLASS.equals(format)) {
            try {
                Class<?> bundleClass = loader.loadClass(bundleName);
                if (!ResourceBundle.class.isAssignableFrom(bundleClass)) {
                    throw new ClassCastException(bundleClass.getName() + " cannot be cast to ResourceBundle");
                }
                bundle = (ResourceBundle)bundleClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException bundleClass) {
            }
            catch (NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else if (JAVA_PROPERTIES.equals(format)) {
            String resourceName = this.toResourceName0(bundleName);
            if (resourceName == null) {
                return null;
            }
            InputStream stream = this.getResourceInputStream(loader, resourceName, reload);
            if (stream != null) {
                try (InputStream inputStream = stream;){
                    bundle = new PropertyResourceBundle(new InputStreamReader(stream, StandardCharsets.UTF_8));
                }
            }
        } else {
            throw new IllegalArgumentException("unknown format: " + format);
        }
        return bundle;
    }

    private String toResourceName0(String bundleName) {
        if (bundleName.contains(SPILT)) {
            return null;
        }
        return this.toResourceName(bundleName, "properties");
    }

    private InputStream getResourceInputStream(ClassLoader classLoader, String resourceName, boolean reloadFlag) throws IOException {
        InputStream is = null;
        if (reloadFlag) {
            URLConnection connection;
            URL url = classLoader.getResource(resourceName);
            if (url != null && (connection = url.openConnection()) != null) {
                connection.setUseCaches(false);
                is = connection.getInputStream();
            }
        } else {
            is = classLoader.getResourceAsStream(resourceName);
        }
        return is;
    }
}

