/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.server.resources.helix;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.apache.helix.BaseDataAccessor;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.constants.InstanceConstants;
import org.apache.helix.controller.rebalancer.strategy.AutoRebalanceStrategy;
import org.apache.helix.controller.rebalancer.waged.WagedRebalancer;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.manager.zk.ZkBucketDataAccessor;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.rest.server.filters.ClusterAuth;
import org.apache.helix.rest.server.resources.helix.AbstractHelixResource;
import org.apache.helix.util.HelixUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClusterAuth
@Path(value="/clusters/{clusterId}/partitionAssignment")
public class ResourceAssignmentOptimizerAccessor
extends AbstractHelixResource {
    private static Logger LOG = LoggerFactory.getLogger((String)ResourceAssignmentOptimizerAccessor.class.getName());
    public static String RESPONSE_HEADER_KEY = "Setting";
    public static String[] RESPONSE_HEADER_FIELDS = new String[]{"instanceFilter", "resourceFilter", "returnFormat"};

    @ResponseMetered(name="write")
    @Timed(name="write")
    @POST
    public Response computePotentialAssignment(@PathParam(value="clusterId") String clusterId, String content) {
        try {
            InputFields inputFields = this.readInput(content);
            ClusterState clusterState = this.readClusterStateAndValidateInput(clusterId, inputFields);
            AssignmentResult result = this.computeOptimalAssignmentForResources(inputFields, clusterState, clusterId);
            return this.JSONRepresentation(result, RESPONSE_HEADER_KEY, this.buildResponseHeaders(inputFields));
        }
        catch (InvalidParameterException ex) {
            return this.badRequest(ex.getMessage());
        }
        catch (JsonProcessingException e) {
            return this.badRequest("Invalid input: Input can not be parsed into a KV map." + e.getMessage());
        }
        catch (OutOfMemoryError e) {
            LOG.error("OutOfMemoryError while calling partitionAssignment", (Throwable)e);
            return this.badRequest("Response size is too large to serialize. Please query by resources or instance filter");
        }
        catch (Exception e) {
            LOG.error("Failed to compute partition assignment", (Throwable)e);
            return this.badRequest("Failed to compute partition assignment: " + e);
        }
    }

    private InputFields readInput(String content) throws JsonProcessingException, IllegalArgumentException {
        ObjectMapper objectMapper = new ObjectMapper();
        InputJsonContent inputJsonContent = (InputJsonContent)objectMapper.readValue(content, InputJsonContent.class);
        InputFields inputFields = new InputFields();
        if (inputJsonContent.instanceChangeMap != null) {
            Optional.ofNullable(inputJsonContent.instanceChangeMap.activateInstances).ifPresent(inputFields.activatedInstances::addAll);
            Optional.ofNullable(inputJsonContent.instanceChangeMap.deactivateInstances).ifPresent(inputFields.deactivatedInstances::addAll);
            Optional.ofNullable(inputJsonContent.instanceChangeMap.instanceConfigs).ifPresent(configs -> configs.forEach(instanceConfig -> inputFields.instanceConfigs.add(instanceConfig.toString())));
        }
        if (inputJsonContent.optionsMap != null) {
            Optional.ofNullable(inputJsonContent.optionsMap.resourceFilter).ifPresent(inputFields.resourceFilter::addAll);
            Optional.ofNullable(inputJsonContent.optionsMap.instanceFilter).ifPresent(inputFields.instanceFilter::addAll);
            inputFields.returnFormat = Optional.ofNullable(inputJsonContent.optionsMap.returnFormat).orElse(AssignmentFormat.IdealStateFormat);
        }
        return inputFields;
    }

    private ClusterState readClusterStateAndValidateInput(String clusterId, InputFields inputFields) throws InvalidParameterException {
        this.validateNoIntxnInstanceChange(inputFields);
        ClusterState clusterState = new ClusterState();
        ConfigAccessor cfgAccessor = this.getConfigAccessor();
        HelixDataAccessor dataAccessor = this.getDataAccssor(clusterId);
        clusterState.resources = dataAccessor.getChildNames(dataAccessor.keyBuilder().idealStates());
        HashSet<String> liveInstancesSet = new HashSet<String>(dataAccessor.getChildNames(dataAccessor.keyBuilder().liveInstances()));
        liveInstancesSet.addAll(inputFields.activatedInstances);
        liveInstancesSet.removeAll(inputFields.deactivatedInstances);
        Map instanceConfigMap = dataAccessor.getChildValuesMap(dataAccessor.keyBuilder().instanceConfigs(), true);
        for (String instanceConfig : inputFields.instanceConfigs) {
            try {
                InstanceConfig instanceConfigOverride = new InstanceConfig(ResourceAssignmentOptimizerAccessor.toZNRecord(instanceConfig));
                instanceConfigMap.put(instanceConfigOverride.getInstanceName(), instanceConfigOverride);
            }
            catch (Exception e) {
                throw new InvalidParameterException("instanceConfig: " + instanceConfig + "is not a valid instanceConfig");
            }
        }
        for (String instance : inputFields.activatedInstances) {
            if (instanceConfigMap.containsKey(instance)) {
                ((InstanceConfig)instanceConfigMap.get(instance)).setInstanceOperation(InstanceConstants.InstanceOperation.ENABLE);
                continue;
            }
            throw new InvalidParameterException("instance: " + instance + "does not have instanceConfig");
        }
        for (String instance : inputFields.deactivatedInstances) {
            if (!instanceConfigMap.containsKey(instance)) continue;
            ((InstanceConfig)instanceConfigMap.get(instance)).setInstanceOperation(InstanceConstants.InstanceOperation.DISABLE);
        }
        ClusterConfig clusterConfig = cfgAccessor.getClusterConfig(clusterId);
        clusterConfig.setDelayRebalaceEnabled(false);
        clusterState.clusterConfig = clusterConfig;
        clusterState.liveInstances = new ArrayList<String>(liveInstancesSet);
        clusterState.instanceConfigs.addAll(instanceConfigMap.values());
        return clusterState;
    }

    private AssignmentResult computeOptimalAssignmentForResources(InputFields inputFields, ClusterState clusterState, String clusterId) throws Exception {
        AssignmentResult result = new AssignmentResult();
        HelixDataAccessor dataAccessor = this.getDataAccssor(clusterId);
        ArrayList<IdealState> wagedResourceIdealState = new ArrayList<IdealState>();
        for (String resource : clusterState.resources) {
            IdealState idealState = (IdealState)dataAccessor.getProperty(dataAccessor.keyBuilder().idealStates(resource));
            if (idealState.getRebalancerClassName() != null && idealState.getRebalancerClassName().equals(WagedRebalancer.class.getName())) {
                wagedResourceIdealState.add(idealState);
                continue;
            }
            if (!inputFields.resourceFilter.isEmpty() && !inputFields.resourceFilter.contains(resource)) continue;
            if (idealState.getRebalanceMode() == IdealState.RebalanceMode.FULL_AUTO) {
                String rebalanceStrategy = idealState.getRebalanceStrategy();
                if (rebalanceStrategy == null || rebalanceStrategy.equalsIgnoreCase("DEFAULT")) {
                    rebalanceStrategy = AutoRebalanceStrategy.class.getName();
                }
                TreeMap<String, Map<String, String>> partitionAssignments = new TreeMap<String, Map<String, String>>(HelixUtil.getIdealAssignmentForFullAuto((ClusterConfig)clusterState.clusterConfig, clusterState.instanceConfigs, clusterState.liveInstances, (IdealState)idealState, new ArrayList(idealState.getPartitionSet()), (String)rebalanceStrategy));
                this.instanceFilter(inputFields, partitionAssignments, resource, result);
                continue;
            }
            if (idealState.getRebalanceMode() != IdealState.RebalanceMode.SEMI_AUTO) continue;
            LOG.error("Resource" + resource + "is in SEMI_AUTO mode. Skip partition assignment computation.");
        }
        if (!wagedResourceIdealState.isEmpty()) {
            this.computeWagedAssignmentResult(wagedResourceIdealState, inputFields, clusterState, clusterId, result);
        }
        return this.updateAssignmentFormat(inputFields, result);
    }

    private AssignmentResult updateAssignmentFormat(InputFields inputFields, AssignmentResult idealStateFormatResult) {
        if (inputFields.returnFormat.equals((Object)AssignmentFormat.CurrentStateFormat)) {
            AssignmentResult currentStateFormatResult = new AssignmentResult();
            idealStateFormatResult.forEach((resourceKey, partitionMap) -> partitionMap.forEach((partitionKey, instanceMap) -> instanceMap.forEach((instanceKey, instanceState) -> currentStateFormatResult.computeIfAbsent(instanceKey, x -> new HashMap()).computeIfAbsent(resourceKey, y -> new HashMap()).put(partitionKey, instanceState))));
            return currentStateFormatResult;
        }
        return idealStateFormatResult;
    }

    private void validateNoIntxnInstanceChange(InputFields inputFields) {
        HashSet<String> tempSet = new HashSet<String>();
        ArrayList<Collection> inputs = new ArrayList<Collection>();
        inputs.add(inputFields.activatedInstances);
        inputs.add(inputFields.deactivatedInstances);
        inputs.sort(Comparator.comparingInt(Collection::size));
        for (int i = 0; i < inputs.size() - 1; ++i) {
            for (String s : (Collection)inputs.get(i)) {
                if (tempSet.add(s)) continue;
                throw new InvalidParameterException("Invalid input: instance [" + s + "] exist in more than one field in InstanceChange.");
            }
        }
        for (String s : (Collection)inputs.get(inputs.size() - 1)) {
            if (!tempSet.contains(s)) continue;
            throw new InvalidParameterException("Invalid input: instance [" + s + "] exist in more than one field in InstanceChange.");
        }
    }

    private void computeWagedAssignmentResult(List<IdealState> wagedResourceIdealState, InputFields inputFields, ClusterState clusterState, String clusterId, AssignmentResult result) {
        ConfigAccessor cfgAccessor = this.getConfigAccessor();
        ArrayList<ResourceConfig> wagedResourceConfigs = new ArrayList<ResourceConfig>();
        for (IdealState idealState : wagedResourceIdealState) {
            ResourceConfig resourceConfig = cfgAccessor.getResourceConfig(clusterId, idealState.getResourceName());
            if (resourceConfig == null) continue;
            wagedResourceConfigs.add(resourceConfig);
        }
        Map wagedAssignmentResult = HelixUtil.getTargetAssignmentForWagedFullAuto((ZkBucketDataAccessor)this.getZkBucketDataAccessor(), (BaseDataAccessor)new ZkBaseDataAccessor(this.getRealmAwareZkClient()), (ClusterConfig)clusterState.clusterConfig, clusterState.instanceConfigs, clusterState.liveInstances, wagedResourceIdealState, wagedResourceConfigs);
        for (Map.Entry wagedAssignment : wagedAssignmentResult.entrySet()) {
            String resource = (String)wagedAssignment.getKey();
            if (!inputFields.resourceFilter.isEmpty() && !inputFields.resourceFilter.contains(resource)) continue;
            TreeMap<String, Map<String, String>> partitionAssignments = new TreeMap<String, Map<String, String>>();
            ((ResourceAssignment)wagedAssignment.getValue()).getMappedPartitions().forEach(partition -> partitionAssignments.put(partition.getPartitionName(), ((ResourceAssignment)wagedAssignment.getValue()).getReplicaMap(partition)));
            this.instanceFilter(inputFields, partitionAssignments, resource, result);
        }
    }

    private void instanceFilter(InputFields inputFields, Map<String, Map<String, String>> partitionAssignments, String resource, AssignmentResult result) {
        if (!inputFields.instanceFilter.isEmpty()) {
            Iterator<Map.Entry<String, Map<String, String>>> partitionAssignmentIt = partitionAssignments.entrySet().iterator();
            while (partitionAssignmentIt.hasNext()) {
                Map.Entry<String, Map<String, String>> partitionAssignment = partitionAssignmentIt.next();
                Map<String, String> instanceStates = partitionAssignment.getValue();
                instanceStates.entrySet().removeIf(e -> !inputFields.instanceFilter.isEmpty() && !inputFields.instanceFilter.contains(e.getKey()));
                if (!instanceStates.isEmpty()) continue;
                partitionAssignmentIt.remove();
            }
        }
        result.put(resource, partitionAssignments);
    }

    private Map<String, Object> buildResponseHeaders(InputFields inputFields) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put(RESPONSE_HEADER_FIELDS[0], inputFields.instanceFilter);
        headers.put(RESPONSE_HEADER_FIELDS[1], inputFields.resourceFilter);
        headers.put(RESPONSE_HEADER_FIELDS[2], inputFields.returnFormat.name());
        return headers;
    }

    private static class OptionsMap {
        @JsonProperty(value="InstanceFilter")
        Set<String> instanceFilter;
        @JsonProperty(value="ResourceFilter")
        Set<String> resourceFilter;
        @JsonProperty(value="ReturnFormat")
        AssignmentFormat returnFormat;

        private OptionsMap() {
        }
    }

    private static enum AssignmentFormat {
        IdealStateFormat,
        CurrentStateFormat;

    }

    private static class InstanceChangeMap {
        @JsonProperty(value="InstanceConfigs")
        JsonNode instanceConfigs;
        @JsonProperty(value="ActivateInstances")
        List<String> activateInstances;
        @JsonProperty(value="DeactivateInstances")
        List<String> deactivateInstances;

        private InstanceChangeMap() {
        }
    }

    private static class InputJsonContent {
        @JsonProperty(value="InstanceChange")
        InstanceChangeMap instanceChangeMap;
        @JsonProperty(value="Options")
        OptionsMap optionsMap;

        private InputJsonContent() {
        }
    }

    private static class AssignmentResult
    extends HashMap<String, Map<String, Map<String, String>>> {
    }

    private static class ClusterState {
        List<InstanceConfig> instanceConfigs = new ArrayList<InstanceConfig>();
        ClusterConfig clusterConfig;
        List<String> resources = new ArrayList<String>();
        List<String> liveInstances;

        private ClusterState() {
        }
    }

    private static class InputFields {
        Set<String> activatedInstances = new HashSet<String>();
        Set<String> deactivatedInstances = new HashSet<String>();
        Set<String> instanceConfigs = new HashSet<String>();
        Set<String> instanceFilter = new HashSet<String>();
        Set<String> resourceFilter = new HashSet<String>();
        AssignmentFormat returnFormat = AssignmentFormat.IdealStateFormat;

        private InputFields() {
        }
    }
}

