/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.clusterMaintenanceService;

import java.util.ArrayList;
import java.util.List;

public class MaintenanceManagementInstanceInfo {
    private String _operationResult;
    private OperationalStatus _status;
    private List<String> _messages;

    public MaintenanceManagementInstanceInfo(OperationalStatus status) {
        this._status = status;
        this._messages = new ArrayList<String>();
        this._operationResult = "";
    }

    public MaintenanceManagementInstanceInfo(OperationalStatus status, List<String> messages) {
        this._status = status;
        this._messages = messages;
        this._operationResult = "";
    }

    public MaintenanceManagementInstanceInfo(OperationalStatus status, String newOperationResult) {
        this._status = status;
        this._operationResult = newOperationResult;
        this._messages = new ArrayList<String>();
    }

    public List<String> getMessages() {
        return this._messages;
    }

    public String getOperationResult() {
        return this._operationResult;
    }

    public boolean hasOperationResult() {
        return !this._operationResult.isEmpty();
    }

    public void setOperationResult(String result) {
        this._operationResult = result;
    }

    public void addMessages(List<String> msg) {
        this._messages.addAll(msg);
    }

    public void addMessage(String meg) {
        this._messages.add(meg);
    }

    public boolean isSuccessful() {
        return this._status.equals((Object)OperationalStatus.SUCCESS);
    }

    public void mergeResult(MaintenanceManagementInstanceInfo info) {
        this.mergeResult(info, false);
    }

    public void mergeResult(MaintenanceManagementInstanceInfo info, boolean nonBlockingFailure) {
        if (info == null) {
            return;
        }
        this._messages.addAll(info.getMessages());
        OperationalStatus operationalStatus = this._status = (info.isSuccessful() || nonBlockingFailure) && this.isSuccessful() ? OperationalStatus.SUCCESS : OperationalStatus.FAILURE;
        if (info.hasOperationResult()) {
            this._operationResult = this.hasOperationResult() ? this._operationResult + "," + info.getOperationResult() : info.getOperationResult();
        }
    }

    public static enum OperationalStatus {
        SUCCESS,
        FAILURE;

    }
}

