/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.model.Message;
import org.apache.helix.model.Partition;

public class MessageOutput {
    private final Map<String, Map<Partition, List<Message>>> _messagesMap = new HashMap<String, Map<Partition, List<Message>>>();
    private final List<Message> _statusChangeMessages = new ArrayList<Message>();

    public void addMessage(String resourceName, Partition partition, Message message) {
        if (!this._messagesMap.containsKey(resourceName)) {
            this._messagesMap.put(resourceName, new HashMap());
        }
        if (!this._messagesMap.get(resourceName).containsKey(partition)) {
            this._messagesMap.get(resourceName).put(partition, new ArrayList());
        }
        this._messagesMap.get(resourceName).get(partition).add(message);
    }

    public void addMessages(String resourceName, Partition partition, List<Message> messages) {
        if (!this._messagesMap.containsKey(resourceName)) {
            this._messagesMap.put(resourceName, new HashMap());
        }
        this._messagesMap.get(resourceName).put(partition, messages);
    }

    public void addStatusChangeMessages(List<Message> messages) {
        this._statusChangeMessages.addAll(messages);
    }

    public List<Message> getMessages(String resourceName, Partition resource) {
        Map<Partition, List<Message>> map = this._messagesMap.get(resourceName);
        if (map != null && map.get(resource) != null) {
            return map.get(resource);
        }
        return Collections.emptyList();
    }

    public Map<Partition, List<Message>> getResourceMessageMap(String resourceName) {
        return this._messagesMap.getOrDefault(resourceName, Collections.emptyMap());
    }

    public List<Message> getStatusChangeMessages() {
        return this._statusChangeMessages;
    }

    public String toString() {
        return this._messagesMap.toString();
    }
}

