/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.helix.HelixRebalanceException;
import org.apache.helix.controller.rebalancer.util.WagedValidationUtil;
import org.apache.helix.controller.rebalancer.waged.RebalanceAlgorithm;
import org.apache.helix.controller.rebalancer.waged.model.ClusterModel;
import org.apache.helix.controller.rebalancer.waged.model.OptimalAssignment;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.model.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WagedRebalanceUtil {
    private static final Logger LOG = LoggerFactory.getLogger(WagedRebalanceUtil.class);

    public static Map<String, ResourceAssignment> calculateAssignment(ClusterModel clusterModel, RebalanceAlgorithm algorithm) throws HelixRebalanceException {
        long startTime = System.currentTimeMillis();
        LOG.info("Start calculating for an assignment with algorithm {}", (Object)algorithm.getClass().getSimpleName());
        OptimalAssignment optimalAssignment = algorithm.calculate(clusterModel);
        Map<String, ResourceAssignment> newAssignment = optimalAssignment.getOptimalResourceAssignment();
        LOG.info("Finish calculating an assignment with algorithm {}. Took: {} ms.", (Object)algorithm.getClass().getSimpleName(), (Object)(System.currentTimeMillis() - startTime));
        return newAssignment;
    }

    public static Map<String, Integer> fetchCapacityUsage(String partitionName, ResourceConfig resourceConfig, ClusterConfig clusterConfig) {
        HashMap<String, Map<String, Integer>> capacityMap;
        try {
            capacityMap = resourceConfig == null ? new HashMap() : resourceConfig.getPartitionCapacityMap();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Invalid partition capacity configuration of resource: " + resourceConfig.getResourceName(), ex);
        }
        Map<String, Integer> partitionCapacity = WagedValidationUtil.validateAndGetPartitionCapacity(partitionName, resourceConfig, capacityMap, clusterConfig);
        partitionCapacity.keySet().retainAll(clusterConfig.getInstanceCapacityKeys());
        return partitionCapacity;
    }
}

