/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.impl.client;

import org.apache.helix.zookeeper.api.client.HelixZkClient;
import org.apache.helix.zookeeper.exception.ZkClientException;
import org.apache.helix.zookeeper.zkclient.IZkConnection;
import org.apache.helix.zookeeper.zkclient.ZkConnection;
import org.apache.helix.zookeeper.zkclient.serialize.BasicZkSerializer;
import org.apache.helix.zookeeper.zkclient.serialize.PathBasedZkSerializer;
import org.apache.helix.zookeeper.zkclient.serialize.SerializableSerializer;
import org.apache.helix.zookeeper.zkclient.serialize.ZkSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkClient
extends org.apache.helix.zookeeper.zkclient.ZkClient
implements HelixZkClient {
    private static Logger LOG = LoggerFactory.getLogger(ZkClient.class);
    public static final int DEFAULT_OPERATION_TIMEOUT = 86400000;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 60000;
    public static final int DEFAULT_SESSION_TIMEOUT = 30000;

    public ZkClient(IZkConnection zkConnection, int connectionTimeout, long operationRetryTimeout, PathBasedZkSerializer zkSerializer, String monitorType, String monitorKey, String monitorInstanceName, boolean monitorRootPathOnly, boolean connectOnInit, boolean usePersistWatcher) {
        super(zkConnection, connectionTimeout, operationRetryTimeout, zkSerializer, monitorType, monitorKey, monitorInstanceName, monitorRootPathOnly, connectOnInit, usePersistWatcher);
    }

    public ZkClient(IZkConnection zkConnection, int connectionTimeout, long operationRetryTimeout, PathBasedZkSerializer zkSerializer, String monitorType, String monitorKey, String monitorInstanceName, boolean monitorRootPathOnly) {
        this(zkConnection, connectionTimeout, operationRetryTimeout, zkSerializer, monitorType, monitorKey, monitorInstanceName, monitorRootPathOnly, true, false);
    }

    public ZkClient(IZkConnection connection, int connectionTimeout, PathBasedZkSerializer zkSerializer, String monitorType, String monitorKey, long operationRetryTimeout) {
        this(connection, connectionTimeout, operationRetryTimeout, zkSerializer, monitorType, monitorKey, null, true);
    }

    public ZkClient(IZkConnection connection, int connectionTimeout, PathBasedZkSerializer zkSerializer, String monitorType, String monitorKey) {
        this(connection, connectionTimeout, zkSerializer, monitorType, monitorKey, 86400000L);
    }

    public ZkClient(String zkServers, String monitorType, String monitorKey) {
        this(new ZkConnection(zkServers, 30000), Integer.MAX_VALUE, new BasicZkSerializer(new SerializableSerializer()), monitorType, monitorKey);
    }

    public ZkClient(String zkServers, int sessionTimeout, int connectionTimeout, PathBasedZkSerializer zkSerializer, String monitorType, String monitorKey) {
        this(new ZkConnection(zkServers, sessionTimeout), connectionTimeout, zkSerializer, monitorType, monitorKey);
    }

    public ZkClient(IZkConnection connection, int connectionTimeout, PathBasedZkSerializer zkSerializer) {
        this(connection, connectionTimeout, zkSerializer, null, null);
    }

    public ZkClient(IZkConnection connection, int connectionTimeout, ZkSerializer zkSerializer) {
        this(connection, connectionTimeout, new BasicZkSerializer(zkSerializer));
    }

    public ZkClient(IZkConnection connection, int connectionTimeout) {
        this(connection, connectionTimeout, new SerializableSerializer());
    }

    public ZkClient(IZkConnection connection) {
        this(connection, Integer.MAX_VALUE, new SerializableSerializer());
    }

    public ZkClient(String zkServers, int sessionTimeout, int connectionTimeout, ZkSerializer zkSerializer) {
        this((IZkConnection)new ZkConnection(zkServers, sessionTimeout), connectionTimeout, zkSerializer);
    }

    public ZkClient(String zkServers, int sessionTimeout, int connectionTimeout, PathBasedZkSerializer zkSerializer) {
        this((IZkConnection)new ZkConnection(zkServers, sessionTimeout), connectionTimeout, zkSerializer);
    }

    public ZkClient(String zkServers, int sessionTimeout, int connectionTimeout) {
        this((IZkConnection)new ZkConnection(zkServers, sessionTimeout), connectionTimeout, new SerializableSerializer());
    }

    public ZkClient(String zkServers, int connectionTimeout) {
        this((IZkConnection)new ZkConnection(zkServers, 30000), connectionTimeout, new SerializableSerializer());
    }

    public ZkClient(String zkServers) {
        this(zkServers, null, null);
    }

    public ZkClient(String zkServers, int sessionTimeout, int connectionTimeout, ZkSerializer zkSerializer, long operationRetryTimeout) {
        this(new ZkConnection(zkServers, sessionTimeout), connectionTimeout, zkSerializer, operationRetryTimeout);
    }

    public ZkClient(IZkConnection zkConnection, int connectionTimeout, ZkSerializer zkSerializer, long operationRetryTimeout) {
        this(zkConnection, connectionTimeout, operationRetryTimeout, new BasicZkSerializer(zkSerializer), null, null, null, false);
    }

    public static class Builder {
        IZkConnection _connection;
        String _zkServer;
        PathBasedZkSerializer _zkSerializer;
        long _operationRetryTimeout = 86400000L;
        int _connectionTimeout = 60000;
        int _sessionTimeout = 30000;
        String _monitorType;
        String _monitorKey;
        String _monitorInstanceName = null;
        boolean _monitorRootPathOnly = true;
        boolean _connectOnInit = true;
        boolean _usePersistWatcher = false;

        public Builder setConnectOnInit(boolean connectOnInit) {
            this._connectOnInit = connectOnInit;
            return this;
        }

        public Builder setConnection(IZkConnection connection) {
            this._connection = connection;
            return this;
        }

        public Builder setConnectionTimeout(Integer connectionTimeout) {
            this._connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder setZkSerializer(PathBasedZkSerializer zkSerializer) {
            this._zkSerializer = zkSerializer;
            return this;
        }

        public Builder setZkSerializer(ZkSerializer zkSerializer) {
            this._zkSerializer = new BasicZkSerializer(zkSerializer);
            return this;
        }

        public Builder setMonitorType(String monitorType) {
            this._monitorType = monitorType;
            return this;
        }

        public Builder setMonitorKey(String monitorKey) {
            this._monitorKey = monitorKey;
            return this;
        }

        public Builder setMonitorInstanceName(String instanceName) {
            this._monitorInstanceName = instanceName;
            return this;
        }

        public Builder setMonitorRootPathOnly(Boolean monitorRootPathOnly) {
            this._monitorRootPathOnly = monitorRootPathOnly;
            return this;
        }

        public Builder setZkServer(String zkServer) {
            this._zkServer = zkServer;
            return this;
        }

        public Builder setSessionTimeout(Integer sessionTimeout) {
            this._sessionTimeout = sessionTimeout;
            return this;
        }

        public Builder setOperationRetryTimeout(Long operationRetryTimeout) {
            this._operationRetryTimeout = operationRetryTimeout;
            return this;
        }

        public Builder setUsePersistWatcher(boolean usePersistWatcher) {
            this._usePersistWatcher = usePersistWatcher;
            return this;
        }

        public ZkClient build() {
            if (this._connection == null) {
                if (this._zkServer == null) {
                    throw new ZkClientException("Failed to build ZkClient since no connection or ZK server address is specified.");
                }
                this._connection = new ZkConnection(this._zkServer, this._sessionTimeout);
            }
            if (this._zkSerializer == null) {
                this._zkSerializer = new BasicZkSerializer(new SerializableSerializer());
            }
            return new ZkClient(this._connection, this._connectionTimeout, this._operationRetryTimeout, this._zkSerializer, this._monitorType, this._monitorKey, this._monitorInstanceName, this._monitorRootPathOnly, this._connectOnInit, this._usePersistWatcher);
        }
    }
}

