/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.ZooKeeperKeepAliveConnection;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZKTableStateClientSideReader;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

class ZKConnectionRegistry
implements ConnectionRegistry {
    private static final Log LOG = LogFactory.getLog(ZKConnectionRegistry.class);
    ConnectionManager.HConnectionImplementation hci;
    private String clusterId = null;

    ZKConnectionRegistry() {
    }

    @Override
    public void init(Connection connection) {
        if (!(connection instanceof ConnectionManager.HConnectionImplementation)) {
            throw new RuntimeException("This registry depends on HConnectionImplementation");
        }
        this.hci = (ConnectionManager.HConnectionImplementation)connection;
    }

    @Override
    public ServerName getActiveMaster() throws IOException {
        ServerName sn;
        try (ZooKeeperKeepAliveConnection zkw = this.hci.getKeepAliveZooKeeperWatcher();){
            sn = MasterAddressTracker.getMasterAddress(zkw);
        }
        catch (KeeperException e) {
            throw new HBaseIOException((Throwable)e);
        }
        return sn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RegionLocations getMetaRegionLocations() throws IOException {
        try (ZooKeeperKeepAliveConnection zkw = this.hci.getKeepAliveZooKeeperWatcher();){
            StringBuilder str;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Looking up meta region location in ZK, connection=" + this));
            }
            List<ServerName> servers = new MetaTableLocator().blockUntilAvailable((ZooKeeperWatcher)zkw, (long)this.hci.rpcTimeout, this.hci.getConfiguration());
            if (LOG.isTraceEnabled()) {
                if (servers == null) {
                    LOG.trace((Object)("Looked up meta region location, connection=" + this + "; servers = null"));
                } else {
                    str = new StringBuilder();
                    for (ServerName s : servers) {
                        str.append(s.toString());
                        str.append(" ");
                    }
                    LOG.trace((Object)("Looked up meta region location, connection=" + this + "; servers = " + str.toString()));
                }
            }
            if (servers == null) {
                str = null;
                return str;
            }
            HRegionLocation[] locs = new HRegionLocation[servers.size()];
            int i = 0;
            for (ServerName server : servers) {
                HRegionInfo h = RegionReplicaUtil.getRegionInfoForReplica(HRegionInfo.FIRST_META_REGIONINFO, i);
                if (server == null) {
                    locs[i++] = null;
                    continue;
                }
                locs[i++] = new HRegionLocation(h, server, 0L);
            }
            RegionLocations regionLocations = new RegionLocations(locs);
            return regionLocations;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    @Override
    public String getClusterId() {
        if (this.clusterId != null) {
            return this.clusterId;
        }
        try (ZooKeeperKeepAliveConnection zkw = this.hci.getKeepAliveZooKeeperWatcher();){
            this.clusterId = ZKClusterId.readClusterIdZNode(zkw);
            if (this.clusterId == null) {
                LOG.info((Object)"ClusterId read in ZooKeeper is null");
            }
        }
        catch (IOException | KeeperException e) {
            LOG.warn((Object)"Can't retrieve clusterId from Zookeeper", e);
        }
        return this.clusterId;
    }

    @Override
    public boolean isTableOnlineState(TableName tableName, boolean enabled) throws IOException {
        try (ZooKeeperKeepAliveConnection zkw = this.hci.getKeepAliveZooKeeperWatcher();){
            if (enabled) {
                boolean bl = ZKTableStateClientSideReader.isEnabledTable(zkw, tableName);
                return bl;
            }
            boolean bl = ZKTableStateClientSideReader.isDisabledTable(zkw, tableName);
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getCurrentNrHRS() throws IOException {
        try (ZooKeeperKeepAliveConnection zkw = this.hci.getKeepAliveZooKeeperWatcher();){
            int n = ZKUtil.getNumberOfChildren(zkw, zkw.rsZNode);
            return n;
        }
        catch (KeeperException ke) {
            throw new IOException("Unexpected ZooKeeper exception", ke);
        }
    }

    @Override
    public void close() {
    }
}

