/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.ZKConnectionRegistry;

@InterfaceAudience.Private
class ConnectionRegistryFactory {
    ConnectionRegistryFactory() {
    }

    static ConnectionRegistry getRegistry(Connection connection) throws IOException {
        String registryClass = connection.getConfiguration().get("hbase.client.registry.impl", ZKConnectionRegistry.class.getName());
        ConnectionRegistry registry = null;
        try {
            registry = (ConnectionRegistry)Class.forName(registryClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
        registry.init(connection);
        return registry;
    }
}

