/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import org.apache.hadoop.fs.viewfs.ViewFileSystemBaseTest;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestViewFileSystemLinkMergeSlash
extends ViewFileSystemBaseTest {
    private static FileSystem fsDefault;
    private static MiniDFSCluster cluster;
    private static final int NAME_SPACES_COUNT = 3;
    private static final int DATA_NODES_COUNT = 3;
    private static final int FS_INDEX_DEFAULT = 0;
    private static final String LINK_MERGE_SLASH_CLUSTER_1_NAME = "ClusterLMS1";
    private static final String LINK_MERGE_SLASH_CLUSTER_2_NAME = "ClusterLMS2";
    private static final FileSystem[] FS_HDFS;
    private static final Configuration CONF;
    private static final File TEST_DIR;
    private static final String TEST_TEMP_PATH = "/tmp/TestViewFileSystemLinkMergeSlash";
    private static final Logger LOG;

    protected FileSystemTestHelper createFileSystemHelper() {
        return new FileSystemTestHelper(TEST_TEMP_PATH);
    }

    @BeforeClass
    public static void clusterSetupAtBeginning() throws IOException, LoginException, URISyntaxException {
        SupportsBlocks = true;
        CONF.setBoolean("dfs.namenode.delegation.token.always-use", true);
        cluster = new MiniDFSCluster.Builder(CONF).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(3)).numDataNodes(3).build();
        cluster.waitClusterUp();
        for (int i = 0; i < 3; ++i) {
            TestViewFileSystemLinkMergeSlash.FS_HDFS[i] = cluster.getFileSystem(i);
        }
        fsDefault = FS_HDFS[0];
    }

    @AfterClass
    public static void clusterShutdownAtEnd() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Before
    public void setUp() throws Exception {
        this.fsTarget = fsDefault;
        super.setUp();
    }

    void initializeTargetTestRoot() throws IOException {
        this.targetTestRoot = fsDefault.makeQualified(new Path("/"));
        for (FileStatus status : fsDefault.listStatus(this.targetTestRoot)) {
            fsDefault.delete(status.getPath(), true);
        }
    }

    void setupMountPoints() {
        super.setupMountPoints();
        ConfigUtil.addLinkMergeSlash((Configuration)this.conf, (String)LINK_MERGE_SLASH_CLUSTER_1_NAME, (URI)this.targetTestRoot.toUri());
        ConfigUtil.addLinkMergeSlash((Configuration)this.conf, (String)LINK_MERGE_SLASH_CLUSTER_2_NAME, (URI)this.targetTestRoot.toUri());
    }

    int getExpectedDelegationTokenCount() {
        return 1;
    }

    int getExpectedDelegationTokenCountWithCredentials() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConfLinkMergeSlash() throws Exception {
        TEST_DIR.mkdirs();
        String clusterName = "ClusterMerge";
        URI viewFsUri = new URI("viewfs", clusterName, "/", null, null);
        String testFileName = "testLinkMergeSlash";
        File infile = new File(TEST_DIR, testFileName);
        byte[] content = "HelloWorld".getBytes();
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(infile);
            fos.write(content);
        }
        Assert.assertEquals((long)content.length, (long)infile.length());
        Configuration conf = new Configuration();
        ConfigUtil.addLinkMergeSlash((Configuration)conf, (String)clusterName, (URI)TEST_DIR.toURI());
        FileSystem vfs = FileSystem.get((URI)viewFsUri, (Configuration)conf);
        Assert.assertEquals(ViewFileSystem.class, vfs.getClass());
        FileStatus stat = vfs.getFileStatus(new Path(viewFsUri.toString() + testFileName));
        LOG.info("File stat: " + stat);
        vfs.close();
    }

    @Test
    public void testConfLinkMergeSlashWithRegularLinks() throws Exception {
        TEST_DIR.mkdirs();
        String clusterName = "ClusterMerge";
        String expectedErrorMsg1 = "Mount table ClusterMerge has already been configured with a merge slash link";
        String expectedErrorMsg2 = "Mount table ClusterMerge has already been configured with regular links";
        URI viewFsUri = new URI("viewfs", clusterName, "/", null, null);
        Configuration conf = new Configuration();
        ConfigUtil.addLinkMergeSlash((Configuration)conf, (String)clusterName, (URI)TEST_DIR.toURI());
        ConfigUtil.addLink((Configuration)conf, (String)clusterName, (String)"testDir", (URI)TEST_DIR.toURI());
        try {
            FileSystem.get((URI)viewFsUri, (Configuration)conf);
            Assert.fail((String)"Shouldn't allow both merge slash link and regular link on same mount table.");
        }
        catch (IOException e) {
            Assert.assertTrue((String)("Unexpected error message: " + e.getMessage()), (e.getMessage().contains(expectedErrorMsg1) || e.getMessage().contains(expectedErrorMsg2) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testConfLinkMergeSlashWithMountPoint() throws Exception {
        TEST_DIR.mkdirs();
        Configuration conf = new Configuration();
        String clusterName = "ClusterX";
        String mountPoint = "/user";
        URI viewFsUri = new URI("viewfs", clusterName, "/", null, null);
        String expectedErrorMsg = "Invalid linkMergeSlash entry in config: linkMergeSlash./user";
        String mountTableEntry = "fs.viewfs.mounttable." + clusterName + "." + "linkMergeSlash" + "." + mountPoint;
        conf.set(mountTableEntry, TEST_DIR.toURI().toString());
        try {
            FileSystem.get((URI)viewFsUri, (Configuration)conf);
            Assert.fail((String)"Shouldn't allow linkMergeSlash to take extra mount points!");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(expectedErrorMsg));
        }
    }

    @Test
    public void testChildFileSystems() throws Exception {
        URI viewFsUri = new URI("viewfs", LINK_MERGE_SLASH_CLUSTER_1_NAME, "/", null, null);
        FileSystem fs = FileSystem.get((URI)viewFsUri, (Configuration)this.conf);
        FileSystem[] childFs = fs.getChildFileSystems();
        Assert.assertEquals((String)"Unexpected number of child filesystems!", (long)1L, (long)childFs.length);
        Assert.assertEquals((String)"Unexpected child filesystem!", DistributedFileSystem.class, childFs[0].getClass());
    }

    static {
        FS_HDFS = new FileSystem[3];
        CONF = new Configuration();
        TEST_DIR = GenericTestUtils.getTestDir((String)TestViewFileSystemLinkMergeSlash.class.getSimpleName());
        LOG = LoggerFactory.getLogger(TestViewFileSystemLinkMergeSlash.class);
    }
}

