/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.hdfs.server.federation.store.protocol.impl.pb;

import java.io.IOException;

import org.apache.hadoop.hdfs.federation.protocol.proto.HdfsServerFederationProtos.GetSafeModeResponseProto;
import org.apache.hadoop.hdfs.federation.protocol.proto.HdfsServerFederationProtos.GetSafeModeResponseProto.Builder;
import org.apache.hadoop.hdfs.federation.protocol.proto.HdfsServerFederationProtos.GetSafeModeResponseProtoOrBuilder;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetSafeModeResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.impl.pb.PBRecord;

import com.google.protobuf.Message;

/**
 * Protobuf implementation of the state store API object
 * GetSafeModeResponse.
 */
public class GetSafeModeResponsePBImpl extends GetSafeModeResponse
    implements PBRecord {

  private FederationProtocolPBTranslator<GetSafeModeResponseProto,
      Builder, GetSafeModeResponseProtoOrBuilder> translator =
          new FederationProtocolPBTranslator<>(
              GetSafeModeResponseProto.class);

  public GetSafeModeResponsePBImpl() {
  }

  public GetSafeModeResponsePBImpl(GetSafeModeResponseProto proto) {
    this.translator.setProto(proto);
  }

  @Override
  public GetSafeModeResponseProto getProto() {
    return translator.build();
  }

  @Override
  public void setProto(Message proto) {
    this.translator.setProto(proto);
  }

  @Override
  public void readInstance(String base64String) throws IOException {
    this.translator.readInstance(base64String);
  }

  @Override
  public boolean isInSafeMode() {
    return this.translator.getProtoOrBuilder().getIsInSafeMode();
  }

  @Override
  public void setSafeMode(boolean isInSafeMode) {
    this.translator.getBuilder().setIsInSafeMode(isInSafeMode);
  }
}
