/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.client.AuthDataProvider;

public abstract class CustomTokenProvider
implements AuthDataProvider {
    private static final String BLANK_SPACE = " ";
    protected String schemeName;

    @Override
    public boolean hasTokenData() {
        return true;
    }

    @Override
    public byte[] getTokenData() {
        return (this.schemeName + BLANK_SPACE + this.getCustomTokenInfo()).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public void close() throws IOException {
    }

    protected abstract String getCustomTokenInfo();

    public static abstract class CustomTokenProviderBuilder<SELF extends Builder<SELF, T>, T extends CustomTokenProvider>
    implements Builder<SELF, T> {
        protected String schemeName;

        @Override
        public SELF withSchemeName(String schemeName) {
            this.schemeName = schemeName;
            return this.self();
        }

        @Override
        public T build() {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.schemeName), (Object)"CustomTokenProvider must set schemeName");
            T t = this.internalBuild();
            return t;
        }

        protected abstract T internalBuild();

        private SELF self() {
            return (SELF)this;
        }
    }

    protected static interface Builder<SELF extends Builder<SELF, T>, T extends CustomTokenProvider> {
        public SELF withSchemeName(String var1);

        public T build();
    }
}

