/*
 * Decompiled with CFR 0.152.
 */
package org.grails.encoder;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.grails.encoder.CodecIdentifier;

public class DefaultCodecIdentifier
implements CodecIdentifier {
    private final String codecName;
    private final Set<String> codecAliases;

    public DefaultCodecIdentifier(String codecName) {
        this(codecName, (Set<String>)null);
    }

    public DefaultCodecIdentifier(String codecName, String ... codecAliases) {
        this(codecName, (Set<String>)(codecAliases != null ? new HashSet<String>(Arrays.asList(codecAliases)) : null));
    }

    public DefaultCodecIdentifier(String codecName, Set<String> codecAliases) {
        this.codecName = codecName;
        this.codecAliases = codecAliases != null ? Collections.unmodifiableSet(codecAliases) : null;
    }

    @Override
    public String getCodecName() {
        return this.codecName;
    }

    @Override
    public Set<String> getCodecAliases() {
        return this.codecAliases;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.codecAliases == null ? 0 : this.codecAliases.hashCode());
        result = 31 * result + (this.codecName == null ? 0 : this.codecName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultCodecIdentifier other = (DefaultCodecIdentifier)obj;
        if (this.codecAliases == null ? other.codecAliases != null : !this.codecAliases.equals(other.codecAliases)) {
            return false;
        }
        return !(this.codecName == null ? other.codecName != null : !this.codecName.equals(other.codecName));
    }

    public String toString() {
        return "DefaultCodecIdentifier [codecName=" + this.codecName + ", codecAliases=" + String.valueOf(this.codecAliases) + "]";
    }

    @Override
    public boolean isEquivalent(CodecIdentifier other) {
        if (this.codecName.equals(other.getCodecName())) {
            return true;
        }
        if (this.codecAliases != null && this.codecAliases.contains(other.getCodecName())) {
            return true;
        }
        return other.getCodecAliases() != null && other.getCodecAliases().contains(this.codecName);
    }
}

