/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.BitmapStorage;
import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah.IntIteratorOverIteratingRLW;
import com.googlecode.javaewah.IteratingBufferedRunningLengthWord;
import com.googlecode.javaewah.IteratingRLW;
import java.util.Iterator;

public final class IteratorUtil {
    private IteratorUtil() {
    }

    public static IntIterator toSetBitsIntIterator(IteratingRLW i2) {
        return new IntIteratorOverIteratingRLW(i2);
    }

    public static Iterator<Integer> toSetBitsIterator(final IteratingRLW i2) {
        return new Iterator<Integer>(){
            private final IntIterator under;
            {
                this.under = IteratorUtil.toSetBitsIntIterator(i2);
            }

            @Override
            public boolean hasNext() {
                return this.under.hasNext();
            }

            @Override
            public Integer next() {
                return this.under.next();
            }

            @Override
            public void remove() {
            }
        };
    }

    public static void materialize(IteratingRLW i2, BitmapStorage c) {
        do {
            if (i2.getRunningLength() > 0L) {
                c.addStreamOfEmptyWords(i2.getRunningBit(), i2.getRunningLength());
            }
            int il = i2.getNumberOfLiteralWords();
            for (int k = 0; k < il; ++k) {
                c.addWord(i2.getLiteralWordAt(k));
            }
        } while (i2.next());
    }

    public static int cardinality(IteratingRLW i2) {
        int answer = 0;
        do {
            if (i2.getRunningBit()) {
                answer += (int)(i2.getRunningLength() * 64L);
            }
            int lw = i2.getNumberOfLiteralWords();
            for (int k = 0; k < lw; ++k) {
                answer += Long.bitCount(i2.getLiteralWordAt(k));
            }
        } while (i2.next());
        return answer;
    }

    public static IteratingRLW[] toIterators(EWAHCompressedBitmap ... x) {
        IteratingRLW[] X = new IteratingRLW[x.length];
        for (int k = 0; k < X.length; ++k) {
            X[k] = new IteratingBufferedRunningLengthWord(x[k]);
        }
        return X;
    }

    public static long materialize(IteratingRLW i2, BitmapStorage c, long max) {
        long origMax = max;
        do {
            long L;
            if (i2.getRunningLength() > 0L) {
                L = i2.getRunningLength();
                if (L > max) {
                    L = max;
                }
                c.addStreamOfEmptyWords(i2.getRunningBit(), L);
                max -= L;
            }
            L = i2.getNumberOfLiteralWords();
            int k = 0;
            while ((long)k < L) {
                c.addWord(i2.getLiteralWordAt(k));
                ++k;
            }
        } while (max > 0L && i2.next());
        return origMax - max;
    }

    public static EWAHCompressedBitmap materialize(IteratingRLW i2) {
        EWAHCompressedBitmap ewah = new EWAHCompressedBitmap();
        IteratorUtil.materialize(i2, ewah);
        return ewah;
    }
}

