/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.serialization;

import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.serialization.VersionedDataStream;

public class BufferDataOutputStream
extends OutputStream
implements VersionedDataStream,
DataOutput {
    public static final int MIN_TO_COPY = 128;
    protected static final int INITIAL_CAPACITY = 1024;
    protected static final boolean ASCII_STRINGS = Boolean.getBoolean("gemfire.ASCII_STRINGS");
    public static final int SMALLEST_CHUNK_SIZE = 32;
    protected int MIN_CHUNK_SIZE;
    protected LinkedList<ByteBuffer> chunks = null;
    protected int size = 0;
    protected boolean ignoreWrites = false;
    protected Version version;
    protected boolean doNotCopy;
    protected ByteBuffer buffer;
    private boolean writeMode = true;
    private boolean disallowExpansion = false;
    private Error expansionException = null;
    private int memoPosition;

    public BufferDataOutputStream(int initialCapacity, Version version) {
        this(initialCapacity, version, false);
    }

    public BufferDataOutputStream(Version version) {
        this(1024, version, false);
    }

    public BufferDataOutputStream(String s) {
        int maxStrBytes = ASCII_STRINGS ? s.length() : s.length() * 3;
        this.MIN_CHUNK_SIZE = 1024;
        this.buffer = ByteBuffer.allocate(maxStrBytes);
        this.doNotCopy = false;
        this.writeUTFNoLength(s);
    }

    public BufferDataOutputStream(int allocSize, Version version, boolean doNotCopy) {
        this.MIN_CHUNK_SIZE = allocSize < 32 ? 32 : allocSize;
        this.buffer = ByteBuffer.allocate(allocSize);
        this.version = version;
        this.doNotCopy = doNotCopy;
    }

    public BufferDataOutputStream(ByteBuffer initialBuffer, Version version, boolean doNotCopy) {
        int allocSize;
        if (initialBuffer.position() != 0) {
            initialBuffer = initialBuffer.slice();
        }
        this.MIN_CHUNK_SIZE = (allocSize = initialBuffer.capacity()) < 32 ? 32 : allocSize;
        this.buffer = initialBuffer;
        this.version = version;
        this.doNotCopy = doNotCopy;
    }

    public BufferDataOutputStream(byte[] bytes) {
        int len = bytes.length;
        if (len <= 0) {
            throw new IllegalArgumentException("The byte array must not be empty");
        }
        this.MIN_CHUNK_SIZE = len > 32 ? len : 32;
        this.buffer = ByteBuffer.wrap(bytes);
        this.doNotCopy = false;
    }

    public static void flushStream(OutputStream out, ByteBuffer outBuf) throws IOException {
        if (outBuf.position() == 0) {
            return;
        }
        assert (outBuf.hasArray());
        outBuf.flip();
        out.write(outBuf.array(), outBuf.arrayOffset(), outBuf.remaining());
        outBuf.clear();
    }

    public boolean setDoNotCopy(boolean v) {
        boolean result = this.doNotCopy;
        if (result != v) {
            this.doNotCopy = v;
        }
        return result;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    public void disallowExpansion(Error ee) {
        this.disallowExpansion = true;
        this.expansionException = ee;
        this.memoPosition = this.buffer.position();
    }

    public void disallowExpansion() {
        this.disallowExpansion = true;
    }

    @Override
    public void write(int b) {
        if (this.ignoreWrites) {
            return;
        }
        this.checkIfWritable();
        this.ensureCapacity(1);
        this.buffer.put((byte)(b & 0xFF));
    }

    protected void ensureCapacity(int amount) {
        int remainingSpace = this.buffer.capacity() - this.buffer.position();
        if (amount > remainingSpace) {
            this.expand(amount);
        }
    }

    private void expand(int amount) {
        if (this.disallowExpansion) {
            if (this.expansionException != null) {
                this.ignoreWrites = true;
                this.buffer.position(this.memoPosition);
                throw this.expansionException;
            }
            throw new IllegalStateException("initial buffer size was exceeded");
        }
        ByteBuffer oldBuffer = this.buffer;
        if (this.chunks == null) {
            this.chunks = new LinkedList();
        }
        oldBuffer.flip();
        this.size += oldBuffer.remaining();
        this.chunks.add(oldBuffer);
        if (amount < this.MIN_CHUNK_SIZE) {
            amount = this.MIN_CHUNK_SIZE;
        }
        this.buffer = ByteBuffer.allocate(amount);
    }

    protected void checkIfWritable() {
        if (!this.writeMode) {
            throw new IllegalStateException("not in write mode");
        }
    }

    @Override
    public void write(byte[] source, int offset, int len) {
        if (len == 0) {
            return;
        }
        if (this.ignoreWrites) {
            return;
        }
        this.checkIfWritable();
        if (this.doNotCopy && len > 128) {
            this.moveBufferToChunks();
            this.addToChunks(source, offset, len);
        } else {
            int remainingSpace = this.buffer.capacity() - this.buffer.position();
            if (remainingSpace < len) {
                this.buffer.put(source, offset, remainingSpace);
                offset += remainingSpace;
                this.ensureCapacity(len -= remainingSpace);
            }
            this.buffer.put(source, offset, len);
        }
    }

    private void addToChunks(byte[] source, int offset, int len) {
        ByteBuffer bb = ByteBuffer.wrap(source, offset, len).slice();
        bb = bb.slice();
        this.size += bb.remaining();
        this.chunks.add(bb);
    }

    private void addToChunks(ByteBuffer bb) {
        int remaining = bb.remaining();
        if (remaining > 0) {
            this.size += remaining;
            if (bb.position() != 0) {
                bb = bb.slice();
            }
            this.chunks.add(bb);
        }
    }

    public int getByteBufferCount() {
        int result = 0;
        if (this.chunks != null) {
            result += this.chunks.size();
        }
        if (this.buffer.remaining() > 0) {
            ++result;
        }
        return result;
    }

    public void fillByteBufferArray(ByteBuffer[] bbArray, int offset) {
        if (this.chunks != null) {
            for (ByteBuffer bb : this.chunks) {
                bbArray[offset++] = bb;
            }
        }
        if (this.buffer.remaining() > 0) {
            bbArray[offset] = this.buffer;
        }
    }

    private void moveBufferToChunks() {
        ByteBuffer oldBuffer = this.buffer;
        if (this.chunks == null) {
            this.chunks = new LinkedList();
        }
        if (oldBuffer.position() == 0) {
            return;
        }
        oldBuffer.flip();
        this.size += oldBuffer.remaining();
        ByteBuffer bufToAdd = oldBuffer.slice();
        this.chunks.add(bufToAdd);
        int newPos = oldBuffer.limit();
        if (oldBuffer.capacity() - newPos <= 0) {
            this.buffer = ByteBuffer.allocate(this.MIN_CHUNK_SIZE);
        } else {
            oldBuffer.limit(oldBuffer.capacity());
            oldBuffer.position(newPos);
            this.buffer = oldBuffer.slice();
        }
    }

    public int size() {
        if (this.writeMode) {
            return this.size + this.buffer.position();
        }
        return this.size;
    }

    private void consolidateChunks() {
        if (this.chunks != null) {
            int size = this.size();
            ByteBuffer newBuffer = ByteBuffer.allocate(size);
            for (ByteBuffer bb : this.chunks) {
                newBuffer.put(bb);
            }
            this.chunks = null;
            newBuffer.put(this.buffer);
            this.buffer = newBuffer;
            this.buffer.flip();
        }
    }

    private void consolidateChunks(int startPosition) {
        assert (startPosition < 32);
        int size = this.size() - startPosition;
        ByteBuffer newBuffer = ByteBuffer.allocate(size);
        if (this.chunks != null) {
            this.chunks.getFirst().position(startPosition);
            for (ByteBuffer bb : this.chunks) {
                newBuffer.put(bb);
            }
            this.chunks = null;
        } else {
            this.buffer.position(startPosition);
        }
        newBuffer.put(this.buffer);
        newBuffer.flip();
        this.buffer = newBuffer;
    }

    public void rewind() {
        this.finishWriting();
        this.size = 0;
        if (this.chunks != null) {
            for (ByteBuffer bb : this.chunks) {
                bb.rewind();
                this.size += bb.remaining();
            }
        }
        this.buffer.rewind();
        this.size += this.buffer.remaining();
    }

    public void reset() {
        this.size = 0;
        if (this.chunks != null) {
            this.chunks.clear();
            this.chunks = null;
        }
        this.buffer.clear();
        this.writeMode = true;
        this.ignoreWrites = false;
        this.disallowExpansion = false;
        this.expansionException = null;
    }

    @Override
    public void flush() {
    }

    public void finishWriting() {
        if (this.writeMode) {
            this.ignoreWrites = false;
            this.writeMode = false;
            this.buffer.flip();
            this.size += this.buffer.remaining();
        }
    }

    public ByteBuffer finishWritingAndReturnUnusedBuffer() {
        this.finishWriting();
        ByteBuffer result = this.buffer.duplicate();
        if (result.remaining() == 0) {
            result.limit(result.capacity());
            return result;
        }
        int newPos = result.limit();
        if (result.capacity() - newPos > 0) {
            result.limit(result.capacity());
            result.position(newPos);
            return result.slice();
        }
        return null;
    }

    @Override
    public void close() {
        this.reset();
    }

    public ByteBuffer toByteBuffer() {
        this.finishWriting();
        this.consolidateChunks();
        return this.buffer;
    }

    public ByteBuffer toByteBuffer(int startPosition) {
        this.finishWriting();
        this.consolidateChunks(startPosition);
        return this.buffer;
    }

    public byte[] toByteArray() {
        ByteBuffer bb = this.toByteBuffer();
        if (bb.hasArray() && bb.arrayOffset() == 0 && bb.limit() == bb.capacity()) {
            return bb.array();
        }
        ByteBuffer tmp = ByteBuffer.allocate(bb.remaining());
        tmp.put(bb);
        tmp.flip();
        this.buffer = tmp;
        return this.buffer.array();
    }

    protected void flushBuffer(SocketChannel sc, ByteBuffer out) throws IOException {
        if (out.position() == 0) {
            return;
        }
        out.flip();
        while (out.remaining() > 0) {
            sc.write(out);
        }
        out.clear();
    }

    public InputStream getInputStream() {
        return new HDInputStream();
    }

    @Override
    public void writeBoolean(boolean v) {
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) {
        this.write(v);
    }

    @Override
    public void writeShort(int v) {
        if (this.ignoreWrites) {
            return;
        }
        this.checkIfWritable();
        this.ensureCapacity(2);
        this.buffer.putShort((short)(v & 0xFFFF));
    }

    @Override
    public void writeChar(int v) {
        if (this.ignoreWrites) {
            return;
        }
        this.checkIfWritable();
        this.ensureCapacity(2);
        this.buffer.putChar((char)v);
    }

    @Override
    public void writeInt(int v) {
        if (this.ignoreWrites) {
            return;
        }
        this.checkIfWritable();
        this.ensureCapacity(4);
        this.buffer.putInt(v);
    }

    @Override
    public void writeLong(long v) {
        if (this.ignoreWrites) {
            return;
        }
        this.checkIfWritable();
        this.ensureCapacity(8);
        this.buffer.putLong(v);
    }

    public LongUpdater reserveLong() {
        if (this.ignoreWrites) {
            return null;
        }
        this.checkIfWritable();
        this.ensureCapacity(8);
        LongUpdater result = new LongUpdater(this.buffer);
        this.buffer.putLong(0L);
        return result;
    }

    @Override
    public void writeFloat(float v) {
        if (this.ignoreWrites) {
            return;
        }
        this.checkIfWritable();
        this.ensureCapacity(4);
        this.buffer.putFloat(v);
    }

    @Override
    public void writeDouble(double v) {
        if (this.ignoreWrites) {
            return;
        }
        this.checkIfWritable();
        this.ensureCapacity(8);
        this.buffer.putDouble(v);
    }

    @Override
    public void writeBytes(String str) {
        if (this.ignoreWrites) {
            return;
        }
        this.checkIfWritable();
        int strlen = str.length();
        if (strlen > 0) {
            this.ensureCapacity(strlen);
            if (this.buffer.hasArray()) {
                int pos = this.buffer.position();
                str.getBytes(0, strlen, this.buffer.array(), this.buffer.arrayOffset() + pos);
                this.buffer.position(pos + strlen);
            } else {
                byte[] bytes = new byte[strlen];
                str.getBytes(0, strlen, bytes, 0);
                this.buffer.put(bytes);
            }
        }
    }

    @Override
    public void writeChars(String s) {
        if (this.ignoreWrites) {
            return;
        }
        this.checkIfWritable();
        int len = s.length();
        if (len > 0) {
            this.ensureCapacity(len * 2);
            for (int i = 0; i < len; ++i) {
                this.buffer.putChar(s.charAt(i));
            }
        }
    }

    @Override
    public void writeUTF(String str) throws UTFDataFormatException {
        if (this.ignoreWrites) {
            return;
        }
        this.checkIfWritable();
        if (ASCII_STRINGS) {
            this.writeAsciiUTF(str, true);
        } else {
            this.writeFullUTF(str, true);
        }
    }

    private void writeAsciiUTF(String str, boolean encodeLength) throws UTFDataFormatException {
        int strlen = str.length();
        if (encodeLength && strlen > 65535) {
            throw new UTFDataFormatException();
        }
        int maxLen = strlen;
        if (encodeLength) {
            maxLen += 2;
        }
        this.ensureCapacity(maxLen);
        if (encodeLength) {
            this.buffer.putShort((short)strlen);
        }
        if (this.buffer.hasArray()) {
            int pos = this.buffer.position();
            str.getBytes(0, strlen, this.buffer.array(), this.buffer.arrayOffset() + pos);
            this.buffer.position(pos + strlen);
        } else {
            for (int i = 0; i < strlen; ++i) {
                this.buffer.put((byte)str.charAt(i));
            }
        }
    }

    private void writeFullUTF(String str, boolean encodeLength) throws UTFDataFormatException {
        int strlen = str.length();
        if (encodeLength && strlen > 65535) {
            throw new UTFDataFormatException();
        }
        int maxLen = strlen * 3;
        if (encodeLength) {
            maxLen += 2;
        }
        this.ensureCapacity(maxLen);
        int utfSizeIdx = this.buffer.position();
        if (encodeLength) {
            this.buffer.position(utfSizeIdx + 2);
        }
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.buffer.put((byte)c);
                continue;
            }
            if (c > '\u07ff') {
                this.buffer.put((byte)(0xE0 | c >> 12 & 0xF));
                this.buffer.put((byte)(0x80 | c >> 6 & 0x3F));
                this.buffer.put((byte)(0x80 | c >> 0 & 0x3F));
                continue;
            }
            this.buffer.put((byte)(0xC0 | c >> 6 & 0x1F));
            this.buffer.put((byte)(0x80 | c >> 0 & 0x3F));
        }
        int utflen = this.buffer.position() - utfSizeIdx;
        if (encodeLength) {
            if ((utflen -= 2) > 65535) {
                this.buffer.position(utfSizeIdx);
                throw new UTFDataFormatException();
            }
            this.buffer.putShort(utfSizeIdx, (short)utflen);
        }
    }

    public void writeUTFNoLength(String str) {
        if (this.ignoreWrites) {
            return;
        }
        this.checkIfWritable();
        try {
            if (ASCII_STRINGS) {
                this.writeAsciiUTF(str, false);
            } else {
                this.writeFullUTF(str, false);
            }
        }
        catch (UTFDataFormatException ex) {
            throw new IllegalStateException(String.format("unexpected %s", ex));
        }
    }

    public void write(ByteBuffer bb) {
        if (this.ignoreWrites) {
            return;
        }
        this.checkIfWritable();
        int remaining = bb.remaining();
        if (remaining == 0) {
            return;
        }
        if (this.doNotCopy && remaining > 128) {
            this.moveBufferToChunks();
            this.addToChunks(bb);
        } else {
            int remainingSpace = this.buffer.remaining();
            if (remainingSpace < remaining) {
                int oldLimit = bb.limit();
                bb.limit(bb.position() + remainingSpace);
                this.buffer.put(bb);
                bb.limit(oldLimit);
                this.ensureCapacity(bb.remaining());
            }
            this.buffer.put(bb);
        }
    }

    private class HDInputStream
    extends InputStream {
        private Iterator<ByteBuffer> chunkIt;
        private ByteBuffer bb;

        public HDInputStream() {
            BufferDataOutputStream.this.finishWriting();
            if (BufferDataOutputStream.this.chunks != null) {
                this.chunkIt = BufferDataOutputStream.this.chunks.iterator();
                this.nextChunk();
            } else {
                this.chunkIt = null;
                this.bb = BufferDataOutputStream.this.buffer;
            }
        }

        private void nextChunk() {
            if (this.chunkIt != null) {
                if (this.chunkIt.hasNext()) {
                    this.bb = this.chunkIt.next();
                } else {
                    this.chunkIt = null;
                    this.bb = BufferDataOutputStream.this.buffer;
                }
            } else {
                this.bb = null;
            }
        }

        @Override
        public int available() {
            return BufferDataOutputStream.this.size();
        }

        @Override
        public int read() {
            if (this.available() <= 0) {
                return -1;
            }
            int remaining = this.bb.limit() - this.bb.position();
            while (remaining == 0) {
                this.nextChunk();
                remaining = this.bb.limit() - this.bb.position();
            }
            this.consume(1);
            return this.bb.get() & 0xFF;
        }

        @Override
        public int read(byte[] dst, int off, int len) {
            if (this.available() <= 0) {
                return -1;
            }
            int readCount = 0;
            while (len > 0 && this.bb != null) {
                if (this.bb.limit() == this.bb.position()) {
                    this.nextChunk();
                    continue;
                }
                int remaining = this.bb.limit() - this.bb.position();
                int bytesToRead = len;
                if (len > remaining) {
                    bytesToRead = remaining;
                }
                this.bb.get(dst, off, bytesToRead);
                off += bytesToRead;
                len -= bytesToRead;
                readCount += bytesToRead;
            }
            this.consume(readCount);
            return readCount;
        }

        @Override
        public long skip(long n) {
            long skipsRemaining;
            int remaining = BufferDataOutputStream.this.size();
            if ((long)remaining <= n) {
                this.chunkIt = null;
                this.bb = null;
                this.consume(remaining);
                return remaining;
            }
            long skipped = 0L;
            while ((skipped += this.chunkSkip(skipsRemaining = n - skipped)) != n) {
            }
            return n;
        }

        private long chunkSkip(long n) {
            int remaining = this.bb.limit() - this.bb.position();
            if ((long)remaining <= n) {
                this.bb.position(this.bb.limit());
                this.nextChunk();
                this.consume(remaining);
                return remaining;
            }
            this.bb.position(this.bb.position() + (int)n);
            this.consume((int)n);
            return n;
        }

        private void consume(int c) {
            BufferDataOutputStream.this.size -= c;
        }
    }

    public static class LongUpdater {
        private final ByteBuffer bb;
        private final int pos;

        public LongUpdater(ByteBuffer bb) {
            this.bb = bb;
            this.pos = bb.position();
        }

        public void update(long v) {
            this.bb.putLong(this.pos, v);
        }
    }
}

