/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.offheap;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.internal.JvmSizeUtils;
import org.apache.geode.internal.offheap.Slab;
import org.apache.geode.internal.offheap.SlabImpl;
import org.apache.geode.unsafe.internal.sun.misc.Unsafe;

public class AddressableMemoryManager {
    @Immutable
    private static final Unsafe unsafe;
    private static final int ARRAY_BYTE_BASE_OFFSET;
    private static final String reason;
    @MakeNotStatic
    private static volatile Class dbbClass;
    @MakeNotStatic
    private static volatile Constructor dbbCtor;
    @MakeNotStatic
    private static volatile boolean dbbCreateFailed;
    @MakeNotStatic
    private static volatile Method dbbAddressMethod;
    @MakeNotStatic
    private static volatile boolean dbbAddressFailed;

    public static long allocate(int size) {
        if (unsafe == null) {
            throw new OutOfMemoryError("Off-heap memory is not available because: " + reason);
        }
        try {
            return unsafe.allocateMemory((long)size);
        }
        catch (OutOfMemoryError err) {
            String msg = "Failed creating " + size + " bytes of off-heap memory during cache creation.";
            if (err.getMessage() != null && !err.getMessage().isEmpty()) {
                msg = msg + " Cause: " + err.getMessage();
            }
            if (!JvmSizeUtils.is64Bit() && size >= 0x40000000) {
                msg = msg + " The JVM looks like a 32-bit one. For large amounts of off-heap memory a 64-bit JVM is needed.";
            }
            throw new OutOfMemoryError(msg);
        }
    }

    public static void free(long addr) {
        unsafe.freeMemory(addr);
    }

    public static Slab allocateSlab(int size) {
        return new SlabImpl(size);
    }

    public static byte readByte(long addr) {
        return unsafe.getByte(addr);
    }

    public static char readChar(long addr) {
        return unsafe.getChar(null, addr);
    }

    public static short readShort(long addr) {
        return unsafe.getShort(null, addr);
    }

    public static int readInt(long addr) {
        return unsafe.getInt(null, addr);
    }

    public static int readIntVolatile(long addr) {
        return unsafe.getIntVolatile(null, addr);
    }

    public static long readLong(long addr) {
        return unsafe.getLong(null, addr);
    }

    public static long readLongVolatile(long addr) {
        return unsafe.getLongVolatile(null, addr);
    }

    public static void writeByte(long addr, byte value) {
        unsafe.putByte(addr, value);
    }

    public static void writeInt(long addr, int value) {
        unsafe.putInt(null, addr, value);
    }

    public static void writeIntVolatile(long addr, int value) {
        unsafe.putIntVolatile(null, addr, value);
    }

    public static boolean writeIntVolatile(long addr, int expected, int value) {
        return unsafe.compareAndSwapInt(null, addr, expected, value);
    }

    public static void writeLong(long addr, long value) {
        unsafe.putLong(null, addr, value);
    }

    public static void writeLongVolatile(long addr, long value) {
        unsafe.putLongVolatile(null, addr, value);
    }

    public static boolean writeLongVolatile(long addr, long expected, long value) {
        return unsafe.compareAndSwapLong(null, addr, expected, value);
    }

    public static void readBytes(long addr, byte[] bytes, int bytesOffset, int size) {
        if (size < 0) {
            throw new AssertionError((Object)("Size=" + size + ", but size must be >= 0"));
        }
        assert (bytesOffset >= 0) : "byteOffset=" + bytesOffset;
        assert (bytesOffset + size <= bytes.length) : "byteOffset=" + bytesOffset + ",size=" + size + ",bytes.length=" + bytes.length;
        if (size == 0) {
            return;
        }
        unsafe.copyMemory(null, addr, (Object)bytes, (long)(ARRAY_BYTE_BASE_OFFSET + bytesOffset), (long)size);
    }

    public static void copyMemory(long srcAddr, long dstAddr, long size) {
        unsafe.copyMemory(srcAddr, dstAddr, size);
    }

    public static void writeBytes(long addr, byte[] bytes, int bytesOffset, int size) {
        if (size < 0) {
            throw new AssertionError((Object)("Size=" + size + ", but size must be >= 0"));
        }
        assert (bytesOffset >= 0) : "byteOffset=" + bytesOffset;
        assert (bytesOffset + size <= bytes.length) : "byteOffset=" + bytesOffset + ",size=" + size + ",bytes.length=" + bytes.length;
        if (size == 0) {
            return;
        }
        unsafe.copyMemory((Object)bytes, (long)(ARRAY_BYTE_BASE_OFFSET + bytesOffset), null, addr, (long)size);
    }

    public static void fill(long addr, int size, byte fill) {
        unsafe.setMemory(addr, (long)size, fill);
    }

    public static long getDirectByteBufferAddress(ByteBuffer bb) {
        if (!bb.isDirect()) {
            return 0L;
        }
        if (dbbAddressFailed) {
            return 0L;
        }
        Method m = dbbAddressMethod;
        if (m == null) {
            Class<?> c = dbbClass;
            if (c == null) {
                try {
                    c = Class.forName("java.nio.DirectByteBuffer");
                }
                catch (ClassNotFoundException e) {
                    dbbCreateFailed = true;
                    dbbAddressFailed = true;
                    return 0L;
                }
                dbbClass = c;
            }
            try {
                m = c.getDeclaredMethod("address", new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                dbbClass = null;
                dbbAddressFailed = true;
                return 0L;
            }
            m.setAccessible(true);
            dbbAddressMethod = m;
        }
        try {
            return (Long)m.invoke((Object)bb, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            dbbClass = null;
            dbbAddressMethod = null;
            dbbAddressFailed = true;
            return 0L;
        }
    }

    static ByteBuffer createDirectByteBuffer(long address, int size) {
        if (dbbCreateFailed) {
            return null;
        }
        Constructor<?> ctor = dbbCtor;
        if (ctor == null) {
            Class<?> c = dbbClass;
            if (c == null) {
                try {
                    c = Class.forName("java.nio.DirectByteBuffer");
                }
                catch (ClassNotFoundException e) {
                    dbbCreateFailed = true;
                    dbbAddressFailed = true;
                    return null;
                }
                dbbClass = c;
            }
            try {
                ctor = c.getDeclaredConstructor(Long.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException | SecurityException e) {
                dbbClass = null;
                dbbCreateFailed = true;
                return null;
            }
            ctor.setAccessible(true);
            dbbCtor = ctor;
        }
        try {
            return (ByteBuffer)ctor.newInstance(address, size);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            dbbClass = null;
            dbbCtor = null;
            dbbCreateFailed = true;
            return null;
        }
    }

    static {
        Unsafe tmp = null;
        String tmpReason = null;
        try {
            tmp = new Unsafe();
        }
        catch (RuntimeException ignore) {
            tmpReason = ignore.toString();
        }
        catch (Error ignore) {
            tmpReason = ignore.toString();
        }
        reason = tmpReason;
        unsafe = tmp;
        ARRAY_BYTE_BASE_OFFSET = unsafe != null ? unsafe.arrayBaseOffset(byte[].class) : 0;
        dbbClass = null;
        dbbCtor = null;
        dbbCreateFailed = false;
        dbbAddressMethod = null;
        dbbAddressFailed = false;
    }
}

