/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tx;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.geode.GemFireException;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.cache.CommitConflictException;
import org.apache.geode.cache.TransactionDataNodeHasDepartedException;
import org.apache.geode.cache.TransactionException;
import org.apache.geode.cache.TransactionInDoubtException;
import org.apache.geode.cache.client.internal.ServerRegionDataAccess;
import org.apache.geode.cache.client.internal.ServerRegionProxy;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.TXCommitMessage;
import org.apache.geode.internal.cache.TXLockRequest;
import org.apache.geode.internal.cache.TXRegionLockRequestImpl;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.TXStateStub;
import org.apache.geode.internal.cache.locks.TXRegionLockRequest;
import org.apache.geode.internal.cache.tx.ClientTXRegionStub;
import org.apache.geode.internal.cache.tx.TXRegionStub;
import org.apache.geode.internal.cache.tx.TransactionalOperation;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ClientTXStateStub
extends TXStateStub {
    private static final Logger logger = LogService.getLogger();
    @MutableForTesting
    private static ThreadLocal<List<TransactionalOperation>> recordedTransactionalOperations = null;
    private static final boolean DISABLE_CONFLICT_CHECK_ON_CLIENT = Boolean.getBoolean("gemfire.disableConflictChecksOnClient");
    private final ServerRegionProxy firstProxy;
    private final InternalCache cache;
    private final DistributionManager dm;
    private final List<TransactionalOperation> recordedOperations = Collections.synchronizedList(new LinkedList());
    private ServerLocation serverAffinityLocation;
    private TXLockRequest lockReq;
    private Runnable internalAfterLocalLocks;
    private boolean txRolledback = false;

    public static boolean transactionRecordingEnabled() {
        return !DISABLE_CONFLICT_CHECK_ON_CLIENT || recordedTransactionalOperations != null;
    }

    public static void setTransactionalOperationContainer(ThreadLocal<List<TransactionalOperation>> t) {
        recordedTransactionalOperations = t;
    }

    public ClientTXStateStub(InternalCache cache, DistributionManager dm, TXStateProxy stateProxy, DistributedMember target, InternalRegion firstRegion) {
        super(stateProxy, target);
        this.cache = cache;
        this.dm = dm;
        this.firstProxy = firstRegion.getServerProxy();
        this.firstProxy.getPool().setupServerAffinity(true);
        if (recordedTransactionalOperations != null) {
            recordedTransactionalOperations.set(this.recordedOperations);
        }
    }

    @Override
    public void commit() throws CommitConflictException {
        this.obtainLocalLocks();
        try {
            TXCommitMessage txcm = null;
            try {
                txcm = this.firstProxy.commit(this.proxy.getTxId().getUniqId());
            }
            finally {
                this.firstProxy.getPool().releaseServerAffinity();
            }
            this.afterServerCommit(txcm);
        }
        catch (TransactionDataNodeHasDepartedException e) {
            throw new TransactionInDoubtException(e);
        }
        finally {
            this.lockReq.releaseLocal();
        }
    }

    TXLockRequest createTXLockRequest() {
        return new TXLockRequest();
    }

    TXRegionLockRequestImpl createTXRegionLockRequestImpl(InternalCache cache, LocalRegion region) {
        return new TXRegionLockRequestImpl(cache, region);
    }

    private void obtainLocalLocks() {
        this.lockReq = this.createTXLockRequest();
        for (TransactionalOperation txOp : this.recordedOperations) {
            if (!TransactionalOperation.ServerRegionOperation.lockKeyForTx(txOp.getOperation())) continue;
            TXRegionLockRequest rlr = this.lockReq.getRegionLockRequest(txOp.getRegionName());
            if (rlr == null) {
                rlr = this.createTXRegionLockRequestImpl(this.cache, (LocalRegion)this.cache.getInternalRegionByPath(txOp.getRegionName()));
                this.lockReq.addLocalRequest(rlr);
            }
            if (txOp.getOperation() == TransactionalOperation.ServerRegionOperation.PUT_ALL || txOp.getOperation() == TransactionalOperation.ServerRegionOperation.REMOVE_ALL) {
                Iterator<Object> it = txOp.getKeys().iterator();
                while (it.hasNext()) {
                    rlr.addEntryKey(it.next(), true);
                }
                continue;
            }
            rlr.addEntryKey(txOp.getKey(), TransactionalOperation.ServerRegionOperation.lockKeyForTx(txOp.getOperation()));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("TX: client localLockRequest: {}", (Object)this.lockReq);
        }
        try {
            this.lockReq.obtain(this.cache.getInternalDistributedSystem());
        }
        catch (CommitConflictException e) {
            this.rollback();
            throw e;
        }
        if (this.internalAfterLocalLocks != null) {
            this.internalAfterLocalLocks.run();
        }
    }

    private void afterServerCommit(TXCommitMessage txcm) {
        if (this.internalAfterSendCommit != null) {
            this.internalAfterSendCommit.run();
        }
        if (this.cache == null) {
            return;
        }
        this.cache.getCancelCriterion().checkCancelInProgress(null);
        txcm.setDM(this.dm);
        txcm.setAckRequired(false);
        txcm.setDisableListeners(true);
        this.cache.getTxManager().setTXState(null);
        txcm.hookupRegions(this.dm);
        txcm.basicProcess();
    }

    @Override
    protected TXRegionStub generateRegionStub(InternalRegion region) {
        return new ClientTXRegionStub(region);
    }

    @Override
    protected void validateRegionCanJoinTransaction(InternalRegion region) throws TransactionException {
        if (!region.hasServerProxy()) {
            throw new TransactionException("Region " + region.getName() + " is local to this client and cannot be used in a transaction.");
        }
        if (this.firstProxy != null && this.firstProxy.getPool() != region.getServerProxy().getPool()) {
            throw new TransactionException("Region " + region.getName() + " is using a different server pool than other regions in this transaction.");
        }
    }

    @Override
    public void rollback() {
        if (this.internalAfterSendRollback != null) {
            this.internalAfterSendRollback.run();
        }
        try {
            this.txRolledback = true;
            this.firstProxy.rollback(this.proxy.getTxId().getUniqId());
        }
        finally {
            this.firstProxy.getPool().releaseServerAffinity();
        }
    }

    @Override
    public void afterCompletion(int status) {
        try {
            if (this.txRolledback) {
                return;
            }
            TXCommitMessage txcm = this.firstProxy.afterCompletion(status, this.proxy.getTxId().getUniqId());
            if (status == 3) {
                if (txcm == null) {
                    throw new TransactionInDoubtException("Commit failed on cache server");
                }
                this.afterServerCommit(txcm);
            } else if (status == 4) {
                if (this.internalAfterSendRollback != null) {
                    this.internalAfterSendRollback.run();
                }
                this.firstProxy.getPool().releaseServerAffinity();
            }
        }
        finally {
            if (status == 3) {
                this.lockReq.releaseLocal();
            }
            this.firstProxy.getPool().releaseServerAffinity();
        }
    }

    @Override
    public void beforeCompletion() {
        this.obtainLocalLocks();
        try {
            this.firstProxy.beforeCompletion(this.proxy.getTxId().getUniqId());
        }
        catch (GemFireException e) {
            this.lockReq.releaseLocal();
            this.firstProxy.getPool().releaseServerAffinity();
            throw e;
        }
    }

    @Override
    public InternalDistributedMember getOriginatingMember() {
        return null;
    }

    @Override
    public boolean isMemberIdForwardingRequired() {
        return false;
    }

    @Override
    public TXCommitMessage getCommitMessage() {
        return null;
    }

    @Override
    public void suspend() {
        this.serverAffinityLocation = this.firstProxy.getPool().getServerAffinityLocation();
        this.firstProxy.getPool().releaseServerAffinity();
        if (logger.isDebugEnabled()) {
            logger.debug("TX: suspending transaction: {} server delegate: {}", (Object)this.getTransactionId(), (Object)this.serverAffinityLocation);
        }
    }

    @Override
    public void resume() {
        this.firstProxy.getPool().setupServerAffinity(true);
        this.firstProxy.getPool().setServerAffinityLocation(this.serverAffinityLocation);
        if (logger.isDebugEnabled()) {
            logger.debug("TX: resuming transaction: {} server delegate: {}", (Object)this.getTransactionId(), (Object)this.serverAffinityLocation);
        }
    }

    @Override
    public void recordTXOperation(ServerRegionDataAccess region, TransactionalOperation.ServerRegionOperation op, Object key, Object[] arguments) {
        if (ClientTXStateStub.transactionRecordingEnabled()) {
            this.recordedOperations.add(new TransactionalOperation(this, region.getRegionName(), op, key, arguments));
        }
    }

    public void setAfterLocalLocks(Runnable afterLocalLocks) {
        this.internalAfterLocalLocks = afterLocalLocks;
    }

    public ServerLocation getServerAffinityLocation() {
        return this.serverAffinityLocation;
    }
}

