/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.geode.DataSerializer;
import org.apache.geode.Instantiator;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.InternalInstantiator;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.serialization.VersionOrdinal;

public class SocketMessageWriter {
    private static final int CLIENT_PING_TASK_PERIOD = Integer.getInteger("gemfire.serverToClientPingPeriod", 60000);

    public void writeHandshakeMessage(DataOutputStream dos, byte type, String p_msg, Version clientVersion, byte endpointType, int queueSize) throws IOException {
        String msg = p_msg;
        dos.writeByte(type);
        dos.writeByte(endpointType);
        dos.writeInt(queueSize);
        if (msg == null) {
            msg = "";
        }
        dos.writeUTF(msg);
        if (clientVersion != null && clientVersion.compareTo((VersionOrdinal)Version.GFE_61) >= 0) {
            Instantiator[] instantiators = InternalInstantiator.getInstantiators();
            HashMap instantiatorMap = new HashMap();
            if (instantiators != null && instantiators.length > 0) {
                for (Instantiator instantiator : instantiators) {
                    ArrayList<String> instantiatorAttributes = new ArrayList<String>();
                    instantiatorAttributes.add(instantiator.getClass().toString().substring(6));
                    instantiatorAttributes.add(instantiator.getInstantiatedClass().toString().substring(6));
                    instantiatorMap.put(instantiator.getId(), instantiatorAttributes);
                }
            }
            DataSerializer.writeHashMap(instantiatorMap, dos);
            DataSerializer[] dataSerializers = InternalDataSerializer.getSerializers();
            HashMap dsToSupportedClasses = new HashMap();
            HashMap<Integer, String> dataSerializersMap = new HashMap<Integer, String>();
            if (dataSerializers != null && dataSerializers.length > 0) {
                for (DataSerializer dataSerializer : dataSerializers) {
                    dataSerializersMap.put(dataSerializer.getId(), dataSerializer.getClass().toString().substring(6));
                    if (clientVersion.compareTo((VersionOrdinal)Version.GFE_6516) < 0) continue;
                    ArrayList<String> supportedClassNames = new ArrayList<String>();
                    for (Class<?> clazz : dataSerializer.getSupportedClasses()) {
                        supportedClassNames.add(clazz.getName());
                    }
                    dsToSupportedClasses.put(dataSerializer.getId(), supportedClassNames);
                }
            }
            DataSerializer.writeHashMap(dataSerializersMap, dos);
            if (clientVersion.compareTo((VersionOrdinal)Version.GFE_6516) >= 0) {
                DataSerializer.writeHashMap(dsToSupportedClasses, dos);
            }
            if (clientVersion.compareTo((VersionOrdinal)Version.GEODE_1_5_0) >= 0) {
                dos.writeInt(CLIENT_PING_TASK_PERIOD);
            }
        }
        dos.flush();
    }

    public void writeException(DataOutputStream dos, byte type, Exception ex, Version clientVersion) throws IOException {
        this.writeHandshakeMessage(dos, type, ex.toString(), clientVersion, (byte)0, 0);
    }
}

