/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.geode.cache.IncompatibleVersionException;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.client.protocol.ClientProtocolProcessor;
import org.apache.geode.internal.cache.tier.Acceptor;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.CommunicationMode;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.ClientHealthMonitor;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.SecurityService;

class ProtobufServerConnection
extends ServerConnection {
    private final ClientProtocolProcessor protocolProcessor;
    private boolean cleanedUp;
    private ClientProxyMembershipID clientProxyMembershipID;
    private final BufferedOutputStream output;

    ProtobufServerConnection(Socket socket, InternalCache internalCache, CachedRegionHelper cachedRegionHelper, CacheServerStats stats, int hsTimeout, int socketBufferSize, String communicationModeStr, byte communicationMode, Acceptor acceptor, ClientProtocolProcessor clientProtocolProcessor, SecurityService securityService) throws IOException {
        super(socket, internalCache, cachedRegionHelper, stats, hsTimeout, socketBufferSize, communicationModeStr, communicationMode, acceptor, securityService);
        this.protocolProcessor = clientProtocolProcessor;
        this.output = new BufferedOutputStream(socket.getOutputStream(), socketBufferSize);
        this.setClientProxyMembershipId();
        this.doHandShake(CommunicationMode.ProtobufClientServerProtocol.getModeNumber(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doOneMessage() {
        Socket socket = this.getSocket();
        try {
            InputStream inputStream = socket.getInputStream();
            InternalCache cache = this.getCache();
            cache.setReadSerializedForCurrentThread(true);
            try {
                try {
                    this.protocolProcessor.processMessage(inputStream, this.output);
                }
                finally {
                    this.output.flush();
                }
            }
            finally {
                cache.setReadSerializedForCurrentThread(false);
            }
            if (this.protocolProcessor.socketProcessingIsFinished()) {
                this.setFlagProcessMessagesAsFalse();
            }
        }
        catch (EOFException e) {
            this.setFlagProcessMessagesAsFalse();
            this.setClientDisconnectedException(e);
            logger.debug("Encountered EOF while processing message: {}", (Throwable)e);
        }
        catch (IOException | IncompatibleVersionException e) {
            if (!socket.isClosed()) {
                logger.warn((Object)e);
            }
            this.setFlagProcessMessagesAsFalse();
            this.setClientDisconnectedException(e);
        }
        finally {
            this.acceptor.getClientHealthMonitor().receivedPing(this.clientProxyMembershipID);
        }
    }

    private void setClientProxyMembershipId() {
        ServerLocation serverLocation = new ServerLocation(((InetSocketAddress)this.getSocket().getRemoteSocketAddress()).getHostName(), this.getSocketPort());
        InternalDistributedMember distributedMember = new InternalDistributedMember(serverLocation);
        this.clientProxyMembershipID = new ClientProxyMembershipID(distributedMember);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cleanup() {
        ProtobufServerConnection protobufServerConnection = this;
        synchronized (protobufServerConnection) {
            if (!this.cleanedUp) {
                this.cleanedUp = true;
                this.protocolProcessor.close();
            }
        }
        return super.cleanup();
    }

    @Override
    protected boolean doHandShake(byte endpointType, int queueSize) {
        ClientHealthMonitor clientHealthMonitor = this.getAcceptor().getClientHealthMonitor();
        clientHealthMonitor.registerClient(this.clientProxyMembershipID);
        clientHealthMonitor.addConnection(this.clientProxyMembershipID, this);
        return true;
    }

    @Override
    protected int getClientReadTimeout() {
        return 0;
    }

    @Override
    public boolean isClientServerConnection() {
        return true;
    }
}

