/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionDataStore;
import org.apache.geode.internal.cache.partitioned.PRLocallyDestroyedException;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ManageBackupBucketMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private int bucketId;
    private boolean isRebalance;
    private boolean replaceOfflineData;
    private InternalDistributedMember moveSource;
    private boolean forceCreation = true;

    public ManageBackupBucketMessage() {
    }

    ManageBackupBucketMessage(InternalDistributedMember recipient, int regionId, ReplyProcessor21 processor, int bucketId, boolean isRebalance, boolean replaceOfflineData, InternalDistributedMember moveSource, boolean forceCreation) {
        super(recipient, regionId, processor);
        this.bucketId = bucketId;
        this.isRebalance = isRebalance;
        this.replaceOfflineData = replaceOfflineData;
        this.moveSource = moveSource;
        this.forceCreation = forceCreation;
    }

    public ManageBackupBucketMessage(DataInput in) throws IOException, ClassNotFoundException {
        this.fromData(in, InternalDataSerializer.createDeserializationContext(in));
    }

    @Override
    public int getProcessorType() {
        return 77;
    }

    public static NodeResponse send(InternalDistributedMember recipient, PartitionedRegion r, int bucketId, boolean isRebalance, boolean replaceOfflineData, InternalDistributedMember moveSource, boolean forceCreation) throws ForceReattemptException {
        Assert.assertTrue(recipient != null, "ManageBucketMessage NULL recipient");
        NodeResponse p = new NodeResponse(r.getSystem(), recipient);
        ManageBackupBucketMessage m = new ManageBackupBucketMessage(recipient, r.getPRId(), p, bucketId, isRebalance, replaceOfflineData, moveSource, forceCreation);
        m.setTransactionDistributed(r.getCache().getTxManager().isDistributed());
        p.enableSevereAlertProcessing();
        Set<InternalDistributedMember> failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new ForceReattemptException("Failed sending <" + m + ">");
        }
        return p;
    }

    @Override
    protected boolean operateOnPartitionedRegion(ClusterDistributionManager dm, PartitionedRegion partitionedRegion, long startTime) {
        if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
            logger.trace(LogMarker.DM_VERBOSE, "ManageBucketMessage operateOnRegion: {}", (Object)partitionedRegion.getFullPath());
        }
        partitionedRegion.checkReadiness();
        PartitionedRegionDataStore prDs = partitionedRegion.getDataStore();
        boolean isReady = prDs.isPartitionedRegionReady(partitionedRegion, this.bucketId);
        if (!isReady) {
            this.sendManageBackupBucketReplyMessage(dm, partitionedRegion, startTime, ReplyType.INITIALIZING);
            return false;
        }
        boolean managingBucket = prDs.grabBucket(this.bucketId, this.moveSource, this.forceCreation, this.replaceOfflineData, this.isRebalance, null, false) == PartitionedRegionDataStore.CreateBucketResult.CREATED;
        this.sendManageBackupBucketReplyMessage(dm, partitionedRegion, startTime, managingBucket ? ReplyType.SUCCESS : ReplyType.FAIL);
        return false;
    }

    private void sendManageBackupBucketReplyMessage(ClusterDistributionManager dm, PartitionedRegion partitionedRegion, long startTime, ReplyType type) {
        partitionedRegion.getPrStats().endPartitionMessagesProcessing(startTime);
        switch (type) {
            case INITIALIZING: {
                ManageBackupBucketReplyMessage.sendStillInitializing(this.getSender(), this.getProcessorId(), dm);
                break;
            }
            case FAIL: {
                ManageBackupBucketReplyMessage.sendRefusal(this.getSender(), this.getProcessorId(), dm);
                break;
            }
            case SUCCESS: {
                ManageBackupBucketReplyMessage.sendAcceptance(this.getSender(), this.getProcessorId(), dm);
                break;
            }
            default: {
                throw new RuntimeException("unreachable");
            }
        }
    }

    public int getDSFID() {
        return -125;
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.bucketId = in.readInt();
        this.isRebalance = in.readBoolean();
        this.replaceOfflineData = in.readBoolean();
        boolean hasMoveSource = in.readBoolean();
        if (hasMoveSource) {
            this.moveSource = new InternalDistributedMember();
            InternalDataSerializer.invokeFromData(this.moveSource, in);
        }
        this.forceCreation = in.readBoolean();
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeInt(this.bucketId);
        out.writeBoolean(this.isRebalance);
        out.writeBoolean(this.replaceOfflineData);
        out.writeBoolean(this.moveSource != null);
        if (this.moveSource != null) {
            InternalDataSerializer.invokeToData(this.moveSource, out);
        }
        out.writeBoolean(this.forceCreation);
    }

    @Override
    protected void appendFields(StringBuilder buff) {
        super.appendFields(buff);
        buff.append("; bucketId=").append(this.bucketId);
        buff.append("; isRebalance=").append(this.isRebalance);
        buff.append("; replaceOfflineData=").append(this.replaceOfflineData);
        buff.append("; moveSource=").append(this.moveSource);
        buff.append("; forceCreation=").append(this.forceCreation);
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    public static class NodeResponse
    extends ReplyProcessor21 {
        private volatile ManageBackupBucketReplyMessage msg;

        public NodeResponse(InternalDistributedSystem ds, InternalDistributedMember recipient) {
            super(ds, recipient);
        }

        @Override
        public void process(DistributionMessage m) {
            try {
                if (m instanceof ManageBackupBucketReplyMessage) {
                    ManageBackupBucketReplyMessage reply;
                    this.msg = reply = (ManageBackupBucketReplyMessage)m;
                    if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                        logger.trace(LogMarker.DM_VERBOSE, "NodeResponse return value is {} isInitializng={}", (Object)reply.acceptedBucket, (Object)reply.notYetInitialized);
                    }
                } else {
                    Assert.assertTrue(m instanceof ReplyMessage);
                }
            }
            finally {
                super.process(m);
            }
        }

        @Override
        protected int getAckWaitThreshold() {
            return super.getAckWaitThreshold() * 2;
        }

        public boolean waitForAcceptance() throws ForceReattemptException {
            try {
                this.waitForRepliesUninterruptibly();
            }
            catch (ReplyException e) {
                Throwable t = e.getCause();
                if (t instanceof CacheClosedException) {
                    String m = "NodeResponse got remote CacheClosedException, throwing PartitionedRegionCommunication Exception";
                    logger.debug(m, t);
                    throw new ForceReattemptException(m, t);
                }
                if (t instanceof PRLocallyDestroyedException) {
                    String m = "NodeResponse got local destroy on the PartitionRegion , throwing ForceReattemptException";
                    logger.debug(m, t);
                    throw new ForceReattemptException(m, t);
                }
                if (t instanceof ForceReattemptException) {
                    String m = "NodeResponse got ForceReattemptException due to local destroy on the PartitionRegion";
                    logger.debug(m, t);
                    throw (ForceReattemptException)t;
                }
                e.handleCause();
            }
            return this.msg != null && this.msg.acceptedBucket;
        }

        public boolean rejectedDueToInitialization() {
            return this.msg != null && this.msg.notYetInitialized;
        }
    }

    public static class ManageBackupBucketReplyMessage
    extends ReplyMessage {
        protected boolean acceptedBucket;
        protected boolean notYetInitialized;

        public ManageBackupBucketReplyMessage() {
        }

        public ManageBackupBucketReplyMessage(DataInput in) throws IOException, ClassNotFoundException {
            this.fromData(in, InternalDataSerializer.createDeserializationContext(in));
        }

        private ManageBackupBucketReplyMessage(int processorId, boolean accept, boolean initializing) {
            this.setProcessorId(processorId);
            this.acceptedBucket = accept;
            this.notYetInitialized = initializing;
        }

        boolean isAcceptedBucket() {
            return this.acceptedBucket;
        }

        boolean isNotYetInitialized() {
            return this.notYetInitialized;
        }

        public static void sendRefusal(InternalDistributedMember recipient, int processorId, DistributionManager dm) {
            Assert.assertTrue(recipient != null, "ManageBackupBucketReplyMessage NULL reply message");
            ManageBackupBucketReplyMessage m = new ManageBackupBucketReplyMessage(processorId, false, false);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        public static void sendStillInitializing(InternalDistributedMember recipient, int processorId, DistributionManager dm) {
            ManageBackupBucketReplyMessage m = new ManageBackupBucketReplyMessage(processorId, false, true);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        public static void sendAcceptance(InternalDistributedMember recipient, int processorId, DistributionManager dm) {
            Assert.assertTrue(recipient != null, "ManageBackupBucketReplyMessage NULL reply message");
            ManageBackupBucketReplyMessage m = new ManageBackupBucketReplyMessage(processorId, true, false);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        @Override
        public void process(DistributionManager dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "ManageBackupBucketReplyMessage process invoking reply processor with processorId: {}", (Object)this.processorId);
            }
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                    logger.trace(LogMarker.DM_VERBOSE, "ManageBackupBucketReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "{} processed {}", (Object)processor, (Object)this);
            }
            dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            out.writeBoolean(this.acceptedBucket);
            out.writeBoolean(this.notYetInitialized);
        }

        @Override
        public int getDSFID() {
            return -124;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.acceptedBucket = in.readBoolean();
            this.notYetInitialized = in.readBoolean();
        }

        @Override
        public String toString() {
            return new StringBuffer().append("ManageBucketReplyMessage ").append("processorid=").append(this.processorId).append(" accepted bucket=").append(this.acceptedBucket).append(" isInitializing=").append(this.notYetInitialized).toString();
        }
    }

    private static enum ReplyType {
        INITIALIZING,
        SUCCESS,
        FAIL;

    }
}

