/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.ha;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.internal.cache.ha.HAContainerWrapper;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;

public class HAContainerMap
implements HAContainerWrapper {
    private ConcurrentHashMap map = null;
    private final Map<String, CacheClientProxy> haRegionNameToProxy;

    public HAContainerMap(ConcurrentHashMap containerMap) {
        this.map = containerMap;
        this.haRegionNameToProxy = new ConcurrentHashMap<String, CacheClientProxy>();
    }

    @Override
    public ClientProxyMembershipID getProxyID(String haRegionName) {
        CacheClientProxy proxy = this.haRegionNameToProxy.get(haRegionName);
        if (proxy != null) {
            return proxy.getProxyID();
        }
        return null;
    }

    @Override
    public Object putProxy(String haName, CacheClientProxy proxy) {
        return this.haRegionNameToProxy.put(haName, proxy);
    }

    @Override
    public CacheClientProxy getProxy(String haRegionName) {
        return this.haRegionNameToProxy.get(haRegionName);
    }

    @Override
    public Object removeProxy(String haName) {
        return this.haRegionNameToProxy.remove(haName);
    }

    @Override
    public Object getKey(Object key) {
        Entry entry = (Entry)this.map.get(key);
        return entry == null ? null : entry.getKey();
    }

    @Override
    public String getName() {
        return "HashMap";
    }

    @Override
    public void cleanUp() {
        this.clear();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("containsValue() not supported.");
    }

    public Set entrySet() {
        throw new UnsupportedOperationException("entrySet() not supported.");
    }

    public Object get(Object key) {
        Entry entry = (Entry)this.map.get(key);
        return entry == null ? null : entry.getValue();
    }

    @Override
    public Object getEntry(Object key) {
        return this.map.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Object put(Object key, Object value) {
        Entry old = this.map.put(key, new Entry(key, value));
        return old != null ? old.getValue() : null;
    }

    @Override
    public Object putIfAbsent(Object key, Object value) {
        Entry old = this.map.putIfAbsent(key, new Entry(key, value));
        return old != null ? old.getValue() : null;
    }

    public void putAll(Map t) {
        throw new UnsupportedOperationException("putAll() not supported.");
    }

    public Object remove(Object key) {
        Entry entry = (Entry)this.map.remove(key);
        return entry == null ? null : entry.getValue();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public Collection values() {
        throw new UnsupportedOperationException("values() not supported.");
    }

    protected static class Entry
    implements Map.Entry {
        private Object key = null;
        private Object value = null;

        public Entry(Object key, Object val) {
            if (key == null || val == null) {
                throw new IllegalArgumentException("key or value cannot be null.");
            }
            this.key = key;
            this.value = val;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object val) {
            throw new UnsupportedOperationException("setValue() not supported.");
        }
    }
}

