/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PlaceHolderDiskRegion;
import org.apache.geode.internal.cache.ProxyRegionMap;
import org.apache.geode.internal.cache.RegionMap;
import org.apache.geode.internal.cache.VMLRURegionMap;
import org.apache.geode.internal.cache.VMRegionMap;

class RegionMapFactory {
    RegionMapFactory() {
    }

    public static RegionMap createVM(LocalRegion owner, RegionMap.Attributes attrs, InternalRegionArguments internalRegionArgs) {
        if (owner.isProxy()) {
            return new ProxyRegionMap(owner, attrs, internalRegionArgs);
        }
        if (owner.isEntryEvictionPossible()) {
            return new VMLRURegionMap(owner, attrs, internalRegionArgs);
        }
        return new VMRegionMap(owner, attrs, internalRegionArgs);
    }

    public static RegionMap createVM(PlaceHolderDiskRegion owner, DiskStoreImpl ds, InternalRegionArguments internalRegionArgs) {
        RegionMap.Attributes ma = new RegionMap.Attributes();
        ma.statisticsEnabled = owner.getStatisticsEnabled();
        ma.loadFactor = owner.getLoadFactor();
        ma.initialCapacity = owner.getInitialCapacity();
        ma.concurrencyLevel = owner.getConcurrencyLevel();
        if (owner.getLruAlgorithm() != 0) {
            return new VMLRURegionMap(owner, ma, internalRegionArgs);
        }
        return new VMRegionMap(owner, ma, internalRegionArgs);
    }
}

