/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import io.micrometer.core.instrument.MeterRegistry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.naming.Context;
import javax.transaction.TransactionManager;
import org.apache.geode.CancelCriterion;
import org.apache.geode.LogWriter;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheTransactionManager;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.DiskStoreFactory;
import org.apache.geode.cache.GatewayException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.asyncqueue.AsyncEventQueue;
import org.apache.geode.cache.asyncqueue.AsyncEventQueueFactory;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueImpl;
import org.apache.geode.cache.client.internal.ClientMetadataService;
import org.apache.geode.cache.control.ResourceManager;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.internal.InternalQueryService;
import org.apache.geode.cache.query.internal.QueryMonitor;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache.snapshot.CacheSnapshotService;
import org.apache.geode.cache.util.GatewayConflictResolver;
import org.apache.geode.cache.wan.GatewayReceiver;
import org.apache.geode.cache.wan.GatewayReceiverFactory;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.cache.wan.GatewaySenderFactory;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.i18n.LogWriterI18n;
import org.apache.geode.internal.SystemTimer;
import org.apache.geode.internal.cache.CacheConfig;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.CacheService;
import org.apache.geode.internal.cache.DiskStoreAttributes;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.DiskStoreMonitor;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.ExpirationScheduler;
import org.apache.geode.internal.cache.FilterProfile;
import org.apache.geode.internal.cache.InitialImageOperation;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalCacheServer;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.RegionListener;
import org.apache.geode.internal.cache.TXEntryStateFactory;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TombstoneService;
import org.apache.geode.internal.cache.backup.BackupService;
import org.apache.geode.internal.cache.control.InternalResourceManager;
import org.apache.geode.internal.cache.control.ResourceAdvisor;
import org.apache.geode.internal.cache.event.EventTrackerExpiryTask;
import org.apache.geode.internal.cache.eviction.HeapEvictor;
import org.apache.geode.internal.cache.eviction.OffHeapEvictor;
import org.apache.geode.internal.cache.extension.ExtensionPoint;
import org.apache.geode.internal.cache.persistence.PersistentMemberManager;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.util.UncheckedUtils;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.offheap.MemoryAllocator;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.statistics.StatisticsClock;
import org.apache.geode.management.internal.JmxManagerAdvisor;
import org.apache.geode.management.internal.RestAgent;
import org.apache.geode.pdx.JSONFormatter;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.PdxInstanceFactory;
import org.apache.geode.pdx.PdxSerializer;
import org.apache.geode.pdx.internal.TypeRegistry;
import org.apache.geode.security.NotAuthorizedException;

public class InternalCacheForClientAccess
implements InternalCache {
    private final InternalCache delegate;

    public InternalCacheForClientAccess(InternalCache delegate) {
        this.delegate = delegate;
    }

    private void checkForInternalRegion(Region<?, ?> r) {
        if (r == null) {
            return;
        }
        InternalRegion ir = (InternalRegion)r;
        if (ir.isInternalRegion() && !r.getName().equals("__DynamicRegions") && !r.getName().equals("__ADMIN_CLIENT_HEALTH_MONITORING__")) {
            throw new NotAuthorizedException("The region " + r.getName() + " is an internal region that a client is never allowed to access");
        }
    }

    private void checkSetOfRegions(Set regions) {
        for (Region r : regions) {
            this.checkForInternalRegion(r);
        }
    }

    @Override
    public <K, V> Region<K, V> getRegion(String path) {
        Region result = this.delegate.getRegion(path);
        this.checkForInternalRegion(result);
        return result;
    }

    public <K, V> Region<K, V> getInternalRegion(String path) {
        return this.delegate.getRegion(path);
    }

    @Override
    public <K, V> Region<K, V> getRegion(String path, boolean returnDestroyedRegion) {
        Region result = this.delegate.getRegion(path, returnDestroyedRegion);
        this.checkForInternalRegion(result);
        return UncheckedUtils.uncheckedRegion(result);
    }

    @Override
    public InternalRegion getReinitializingRegion(String fullPath) {
        InternalRegion result = this.delegate.getReinitializingRegion(fullPath);
        this.checkForInternalRegion(result);
        return result;
    }

    @Override
    public <K, V> Region<K, V> getRegionByPath(String path) {
        InternalRegion result = this.delegate.getInternalRegionByPath(path);
        this.checkForInternalRegion(result);
        return UncheckedUtils.uncheckedRegion(result);
    }

    @Override
    public InternalRegion getInternalRegionByPath(String path) {
        InternalRegion result = this.delegate.getInternalRegionByPath(path);
        this.checkForInternalRegion(result);
        return result;
    }

    @Override
    public InternalRegion getRegionByPathForProcessing(String path) {
        InternalRegion result = this.delegate.getRegionByPathForProcessing(path);
        this.checkForInternalRegion(result);
        return result;
    }

    @Override
    public DistributedRegion getRegionInDestroy(String path) {
        DistributedRegion result = this.delegate.getRegionInDestroy(path);
        this.checkForInternalRegion(result);
        return result;
    }

    @Override
    public Set<PartitionedRegion> getPartitionedRegions() {
        Set<PartitionedRegion> result = this.delegate.getPartitionedRegions();
        this.checkSetOfRegions(result);
        return result;
    }

    @Override
    public Set<Region<?, ?>> rootRegions() {
        Set<Region<?, ?>> result = this.delegate.rootRegions();
        this.checkSetOfRegions(result);
        return result;
    }

    @Override
    public Set<Region<?, ?>> rootRegions(boolean includePRAdminRegions) {
        Set<Region<?, ?>> result = this.delegate.rootRegions(includePRAdminRegions);
        this.checkSetOfRegions(result);
        return result;
    }

    @Override
    public Set<InternalRegion> getAllRegions() {
        Set<InternalRegion> result = this.delegate.getAllRegions();
        this.checkSetOfRegions(result);
        return result;
    }

    @Override
    public <K, V> Region<K, V> createVMRegion(String name, RegionAttributes<K, V> p_attrs, InternalRegionArguments internalRegionArgs) throws RegionExistsException, TimeoutException, IOException, ClassNotFoundException {
        if (internalRegionArgs != null && (internalRegionArgs.isInternalRegion() || internalRegionArgs.isUsedForPartitionedRegionBucket() || internalRegionArgs.isUsedForMetaRegion() || internalRegionArgs.isUsedForSerialGatewaySenderQueue() || internalRegionArgs.isUsedForParallelGatewaySenderQueue())) {
            throw new NotAuthorizedException("The region " + name + " is an internal region that a client is never allowed to create");
        }
        return this.delegate.createVMRegion(name, p_attrs, internalRegionArgs);
    }

    public <K, V> Region<K, V> createInternalRegion(String name, RegionAttributes<K, V> p_attrs, InternalRegionArguments internalRegionArgs) throws RegionExistsException, TimeoutException, IOException, ClassNotFoundException {
        return this.delegate.createVMRegion(name, p_attrs, internalRegionArgs);
    }

    @Override
    public Cache getReconnectedCache() {
        Cache reconnectedCache = this.delegate.getReconnectedCache();
        if (reconnectedCache != null) {
            return new InternalCacheForClientAccess((InternalCache)reconnectedCache);
        }
        return null;
    }

    @Override
    public FilterProfile getFilterProfile(String regionName) {
        InternalRegion r = (InternalRegion)this.getRegion(regionName, true);
        if (r != null) {
            return r.getFilterProfile();
        }
        return null;
    }

    @Override
    public <K, V> Region<K, V> basicCreateRegion(String name, RegionAttributes<K, V> attrs) throws RegionExistsException, TimeoutException {
        return this.delegate.basicCreateRegion(name, attrs);
    }

    @Override
    public <K, V> Region<K, V> createVMRegion(String name, RegionAttributes<K, V> aRegionAttributes) throws RegionExistsException, TimeoutException {
        return this.delegate.createVMRegion(name, aRegionAttributes);
    }

    @Override
    public <K, V> Region<K, V> createRegion(String name, RegionAttributes<K, V> aRegionAttributes) throws RegionExistsException, TimeoutException {
        return this.delegate.createRegion(name, aRegionAttributes);
    }

    @Override
    public <K, V> RegionFactory<K, V> createRegionFactory() {
        return this.delegate.createRegionFactory();
    }

    @Override
    public <K, V> RegionFactory<K, V> createRegionFactory(RegionShortcut shortcut) {
        return this.delegate.createRegionFactory(shortcut);
    }

    @Override
    public <K, V> RegionFactory<K, V> createRegionFactory(String regionAttributesId) {
        return this.delegate.createRegionFactory(regionAttributesId);
    }

    @Override
    public <K, V> RegionFactory<K, V> createRegionFactory(RegionAttributes<K, V> regionAttributes) {
        return this.delegate.createRegionFactory(regionAttributes);
    }

    @Override
    public void close(boolean keepAlive) {
        this.delegate.close(keepAlive);
    }

    @Override
    public LogWriterI18n getLoggerI18n() {
        return this.delegate.getLoggerI18n();
    }

    @Override
    public LogWriterI18n getSecurityLoggerI18n() {
        return this.delegate.getSecurityLoggerI18n();
    }

    @Override
    public int getLockTimeout() {
        return this.delegate.getLockTimeout();
    }

    @Override
    public void setLockTimeout(int seconds) {
        this.delegate.setLockTimeout(seconds);
    }

    @Override
    public int getMessageSyncInterval() {
        return this.delegate.getMessageSyncInterval();
    }

    @Override
    public void setMessageSyncInterval(int seconds) {
        this.delegate.setMessageSyncInterval(seconds);
    }

    @Override
    public int getLockLease() {
        return this.delegate.getLockLease();
    }

    @Override
    public void setLockLease(int seconds) {
        this.delegate.setLockLease(seconds);
    }

    @Override
    public int getSearchTimeout() {
        return this.delegate.getSearchTimeout();
    }

    @Override
    public void setSearchTimeout(int seconds) {
        this.delegate.setSearchTimeout(seconds);
    }

    @Override
    public CacheServer addCacheServer() {
        return this.delegate.addCacheServer();
    }

    @Override
    public List<CacheServer> getCacheServers() {
        return this.delegate.getCacheServers();
    }

    @Override
    public void setGatewayConflictResolver(GatewayConflictResolver resolver) {
        this.delegate.setGatewayConflictResolver(resolver);
    }

    @Override
    public GatewayConflictResolver getGatewayConflictResolver() {
        return this.delegate.getGatewayConflictResolver();
    }

    @Override
    public void setIsServer(boolean isServer) {
        this.delegate.setIsServer(isServer);
    }

    @Override
    public boolean isServer() {
        return this.delegate.isServer();
    }

    @Override
    public void readyForEvents() {
        this.delegate.readyForEvents();
    }

    @Override
    public GatewaySenderFactory createGatewaySenderFactory() {
        return this.delegate.createGatewaySenderFactory();
    }

    @Override
    public AsyncEventQueueFactory createAsyncEventQueueFactory() {
        return this.delegate.createAsyncEventQueueFactory();
    }

    @Override
    public GatewayReceiverFactory createGatewayReceiverFactory() {
        return this.delegate.createGatewayReceiverFactory();
    }

    @Override
    public Set<GatewaySender> getGatewaySenders() {
        return this.delegate.getGatewaySenders();
    }

    @Override
    public GatewaySender getGatewaySender(String id) {
        return this.delegate.getGatewaySender(id);
    }

    @Override
    public Set<GatewayReceiver> getGatewayReceivers() {
        return this.delegate.getGatewayReceivers();
    }

    @Override
    public Set<AsyncEventQueue> getAsyncEventQueues() {
        return this.delegate.getAsyncEventQueues();
    }

    @Override
    public AsyncEventQueue getAsyncEventQueue(String id) {
        return this.delegate.getAsyncEventQueue(id);
    }

    @Override
    public Set<DistributedMember> getMembers() {
        return this.delegate.getMembers();
    }

    @Override
    public Set<DistributedMember> getAdminMembers() {
        return this.delegate.getAdminMembers();
    }

    @Override
    public Set<DistributedMember> getMembers(Region region) {
        return this.delegate.getMembers(region);
    }

    @Override
    public CacheSnapshotService getSnapshotService() {
        return this.delegate.getSnapshotService();
    }

    @Override
    public boolean isReconnecting() {
        return this.delegate.isReconnecting();
    }

    @Override
    public boolean waitUntilReconnected(long time, TimeUnit units) throws InterruptedException {
        return this.delegate.waitUntilReconnected(time, units);
    }

    @Override
    public void stopReconnecting() {
        this.delegate.stopReconnecting();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public DistributedSystem getDistributedSystem() {
        return this.delegate.getDistributedSystem();
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.delegate.getResourceManager();
    }

    @Override
    public void setCopyOnRead(boolean copyOnRead) {
        this.delegate.setCopyOnRead(copyOnRead);
    }

    @Override
    public boolean getCopyOnRead() {
        return this.delegate.getCopyOnRead();
    }

    @Override
    public <K, V> RegionAttributes<K, V> getRegionAttributes(String id) {
        return this.delegate.getRegionAttributes(id);
    }

    @Override
    public <K, V> void setRegionAttributes(String id, RegionAttributes<K, V> attrs) {
        this.delegate.setRegionAttributes(id, attrs);
    }

    @Override
    public <K, V> Map<String, RegionAttributes<K, V>> listRegionAttributes() {
        return this.delegate.listRegionAttributes();
    }

    @Override
    public void loadCacheXml(InputStream is) throws TimeoutException, CacheWriterException, GatewayException, RegionExistsException {
        this.delegate.loadCacheXml(is);
    }

    @Override
    public LogWriter getLogger() {
        return this.delegate.getLogger();
    }

    @Override
    public LogWriter getSecurityLogger() {
        return this.delegate.getSecurityLogger();
    }

    @Override
    public DiskStore findDiskStore(String name) {
        return this.delegate.findDiskStore(name);
    }

    @Override
    public DiskStoreFactory createDiskStoreFactory() {
        return this.delegate.createDiskStoreFactory();
    }

    @Override
    public boolean getPdxReadSerialized() {
        return this.delegate.getPdxReadSerialized();
    }

    @Override
    public PdxSerializer getPdxSerializer() {
        return this.delegate.getPdxSerializer();
    }

    @Override
    public String getPdxDiskStore() {
        return this.delegate.getPdxDiskStore();
    }

    @Override
    public boolean getPdxPersistent() {
        return this.delegate.getPdxPersistent();
    }

    @Override
    public boolean getPdxIgnoreUnreadFields() {
        return this.delegate.getPdxIgnoreUnreadFields();
    }

    @Override
    public void registerPdxMetaData(Object instance) {
        this.delegate.registerPdxMetaData(instance);
    }

    @Override
    public CacheTransactionManager getCacheTransactionManager() {
        return this.delegate.getCacheTransactionManager();
    }

    @Override
    public Context getJNDIContext() {
        return this.delegate.getJNDIContext();
    }

    @Override
    public Declarable getInitializer() {
        return this.delegate.getInitializer();
    }

    @Override
    public Properties getInitializerProps() {
        return this.delegate.getInitializerProps();
    }

    @Override
    public CancelCriterion getCancelCriterion() {
        return this.delegate.getCancelCriterion();
    }

    @Override
    public PdxInstanceFactory createPdxInstanceFactory(String className) {
        return this.delegate.createPdxInstanceFactory(className);
    }

    @Override
    public PdxInstance createPdxEnum(String className, String enumName, int enumOrdinal) {
        return this.delegate.createPdxEnum(className, enumName, enumOrdinal);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    @Override
    public ExtensionPoint<Cache> getExtensionPoint() {
        return this.delegate.getExtensionPoint();
    }

    @Override
    public InternalDistributedMember getMyId() {
        return this.delegate.getMyId();
    }

    @Override
    public Collection<DiskStore> listDiskStores() {
        return this.delegate.listDiskStores();
    }

    @Override
    public Collection<DiskStore> listDiskStoresIncludingRegionOwned() {
        return this.delegate.listDiskStoresIncludingRegionOwned();
    }

    @Override
    public CqService getCqService() {
        return this.delegate.getCqService();
    }

    @Override
    public <T extends CacheService> T getService(Class<T> clazz) {
        return this.delegate.getService(clazz);
    }

    @Override
    public <T extends CacheService> Optional<T> getOptionalService(Class<T> clazz) {
        return Optional.ofNullable(this.getService(clazz));
    }

    @Override
    public Collection<CacheService> getServices() {
        return this.delegate.getServices();
    }

    @Override
    public SystemTimer getCCPTimer() {
        return this.delegate.getCCPTimer();
    }

    @Override
    public void cleanupForClient(CacheClientNotifier ccn, ClientProxyMembershipID client) {
        this.delegate.cleanupForClient(ccn, client);
    }

    @Override
    public void purgeCCPTimer() {
        this.delegate.purgeCCPTimer();
    }

    @Override
    public MemoryAllocator getOffHeapStore() {
        return this.delegate.getOffHeapStore();
    }

    @Override
    public DistributedLockService getPartitionedRegionLockService() {
        return this.delegate.getPartitionedRegionLockService();
    }

    @Override
    public PersistentMemberManager getPersistentMemberManager() {
        return this.delegate.getPersistentMemberManager();
    }

    @Override
    public Set<GatewaySender> getAllGatewaySenders() {
        return this.delegate.getAllGatewaySenders();
    }

    @Override
    public CachePerfStats getCachePerfStats() {
        return this.delegate.getCachePerfStats();
    }

    @Override
    public DistributionManager getDistributionManager() {
        return this.delegate.getDistributionManager();
    }

    public void regionReinitialized(Region region) {
        this.delegate.regionReinitialized(region);
    }

    @Override
    public void setRegionByPath(String path, InternalRegion r) {
        this.delegate.setRegionByPath(path, r);
    }

    @Override
    public InternalResourceManager getInternalResourceManager() {
        return this.delegate.getInternalResourceManager();
    }

    @Override
    public ResourceAdvisor getResourceAdvisor() {
        return this.delegate.getResourceAdvisor();
    }

    @Override
    public boolean isCacheAtShutdownAll() {
        return this.delegate.isCacheAtShutdownAll();
    }

    @Override
    public boolean requiresNotificationFromPR(PartitionedRegion r) {
        return this.delegate.requiresNotificationFromPR(r);
    }

    @Override
    public <K, V> RegionAttributes<K, V> invokeRegionBefore(InternalRegion parent, String name, RegionAttributes<K, V> attrs, InternalRegionArguments internalRegionArgs) {
        return this.delegate.invokeRegionBefore(parent, name, attrs, internalRegionArgs);
    }

    @Override
    public void invokeRegionAfter(InternalRegion region) {
        this.delegate.invokeRegionAfter(region);
    }

    @Override
    public void invokeBeforeDestroyed(InternalRegion region) {
        this.delegate.invokeBeforeDestroyed(region);
    }

    @Override
    public void invokeCleanupFailedInitialization(InternalRegion region) {
        this.delegate.invokeCleanupFailedInitialization(region);
    }

    @Override
    public TXManagerImpl getTXMgr() {
        return this.delegate.getTXMgr();
    }

    @Override
    public boolean forcedDisconnect() {
        return this.delegate.forcedDisconnect();
    }

    @Override
    public InternalResourceManager getInternalResourceManager(boolean checkCancellationInProgress) {
        return this.delegate.getInternalResourceManager();
    }

    @Override
    public boolean isCopyOnRead() {
        return this.delegate.isCopyOnRead();
    }

    @Override
    public TombstoneService getTombstoneService() {
        return this.delegate.getTombstoneService();
    }

    @Override
    public QueryService getLocalQueryService() {
        return this.delegate.getLocalQueryService();
    }

    @Override
    public void registerInterestStarted() {
        this.delegate.registerInterestStarted();
    }

    @Override
    public void registerInterestCompleted() {
        this.delegate.registerInterestCompleted();
    }

    @Override
    public void regionReinitializing(String fullPath) {
        this.delegate.regionReinitializing(fullPath);
    }

    @Override
    public void unregisterReinitializingRegion(String fullPath) {
        this.delegate.unregisterReinitializingRegion(fullPath);
    }

    @Override
    public boolean removeRoot(InternalRegion rootRgn) {
        return this.delegate.removeRoot(rootRgn);
    }

    @Override
    public Executor getEventThreadPool() {
        return this.delegate.getEventThreadPool();
    }

    @Override
    public boolean keepDurableSubscriptionsAlive() {
        return this.delegate.keepDurableSubscriptionsAlive();
    }

    @Override
    public CacheClosedException getCacheClosedException(String reason) {
        return this.delegate.getCacheClosedException(reason);
    }

    @Override
    public CacheClosedException getCacheClosedException(String reason, Throwable cause) {
        return this.delegate.getCacheClosedException(reason, cause);
    }

    @Override
    public TypeRegistry getPdxRegistry() {
        return this.delegate.getPdxRegistry();
    }

    @Override
    public DiskStoreImpl getOrCreateDefaultDiskStore() {
        return this.delegate.getOrCreateDefaultDiskStore();
    }

    @Override
    public ExpirationScheduler getExpirationScheduler() {
        return this.delegate.getExpirationScheduler();
    }

    @Override
    public TransactionManager getJTATransactionManager() {
        return this.delegate.getJTATransactionManager();
    }

    @Override
    public TXManagerImpl getTxManager() {
        return this.delegate.getTxManager();
    }

    @Override
    public void beginDestroy(String path, DistributedRegion region) {
        this.delegate.beginDestroy(path, region);
    }

    @Override
    public void endDestroy(String path, DistributedRegion region) {
        this.delegate.endDestroy(path, region);
    }

    @Override
    public ClientMetadataService getClientMetadataService() {
        return this.delegate.getClientMetadataService();
    }

    @Override
    public long cacheTimeMillis() {
        return this.delegate.cacheTimeMillis();
    }

    @Override
    public URL getCacheXmlURL() {
        return this.delegate.getCacheXmlURL();
    }

    @Override
    public List<File> getBackupFiles() {
        return this.delegate.getBackupFiles();
    }

    @Override
    public boolean isClient() {
        return this.delegate.isClient();
    }

    @Override
    public InternalDistributedSystem getInternalDistributedSystem() {
        return this.delegate.getInternalDistributedSystem();
    }

    @Override
    public void addRegionListener(RegionListener regionListener) {
        this.delegate.addRegionListener(regionListener);
    }

    @Override
    public void removeRegionListener(RegionListener regionListener) {
        this.delegate.removeRegionListener(regionListener);
    }

    @Override
    public Set<RegionListener> getRegionListeners() {
        return this.delegate.getRegionListeners();
    }

    @Override
    public CacheConfig getCacheConfig() {
        return this.delegate.getCacheConfig();
    }

    @Override
    public boolean getPdxReadSerializedByAnyGemFireServices() {
        return this.delegate.getPdxReadSerializedByAnyGemFireServices();
    }

    @Override
    public void setDeclarativeCacheConfig(CacheConfig cacheConfig) {
        this.delegate.setDeclarativeCacheConfig(cacheConfig);
    }

    @Override
    public void initializePdxRegistry() {
        this.delegate.initializePdxRegistry();
    }

    @Override
    public void readyDynamicRegionFactory() {
        this.delegate.readyDynamicRegionFactory();
    }

    @Override
    public void setBackupFiles(List<File> backups) {
        this.delegate.setBackupFiles(backups);
    }

    @Override
    public void addDeclarableProperties(Map<Declarable, Properties> mapOfNewDeclarableProps) {
        this.delegate.addDeclarableProperties(mapOfNewDeclarableProps);
    }

    @Override
    public void setInitializer(Declarable initializer, Properties initializerProps) {
        this.delegate.setInitializer(initializer, initializerProps);
    }

    @Override
    public boolean hasPool() {
        return this.delegate.hasPool();
    }

    @Override
    public DiskStoreFactory createDiskStoreFactory(DiskStoreAttributes attrs) {
        return this.delegate.createDiskStoreFactory(attrs);
    }

    @Override
    public BackupService getBackupService() {
        return this.delegate.getBackupService();
    }

    @Override
    @VisibleForTesting
    public Throwable getDisconnectCause() {
        return this.delegate.getDisconnectCause();
    }

    @Override
    public void addPartitionedRegion(PartitionedRegion region) {
        this.delegate.addPartitionedRegion(region);
    }

    @Override
    public void removePartitionedRegion(PartitionedRegion region) {
        this.delegate.removePartitionedRegion(region);
    }

    @Override
    public void addDiskStore(DiskStoreImpl dsi) {
        this.delegate.addDiskStore(dsi);
    }

    @Override
    public TXEntryStateFactory getTXEntryStateFactory() {
        return this.delegate.getTXEntryStateFactory();
    }

    @Override
    public EventTrackerExpiryTask getEventTrackerTask() {
        return this.delegate.getEventTrackerTask();
    }

    @Override
    public void removeDiskStore(DiskStoreImpl diskStore) {
        this.delegate.removeDiskStore(diskStore);
    }

    @Override
    public void addGatewaySender(GatewaySender sender) {
        this.delegate.addGatewaySender(sender);
    }

    @Override
    public void addAsyncEventQueue(AsyncEventQueueImpl asyncQueue) {
        this.delegate.addAsyncEventQueue(asyncQueue);
    }

    @Override
    public void removeAsyncEventQueue(AsyncEventQueue asyncQueue) {
        this.delegate.removeAsyncEventQueue(asyncQueue);
    }

    @Override
    public QueryMonitor getQueryMonitor() {
        return this.delegate.getQueryMonitor();
    }

    @Override
    public void close(String reason, Throwable systemFailureCause, boolean keepAlive, boolean keepDS) {
        this.delegate.close(reason, systemFailureCause, keepAlive, keepDS);
    }

    @Override
    public JmxManagerAdvisor getJmxManagerAdvisor() {
        return this.delegate.getJmxManagerAdvisor();
    }

    @Override
    public List<Properties> getDeclarableProperties(String className) {
        return this.delegate.getDeclarableProperties(className);
    }

    @Override
    public long getUpTime() {
        return this.delegate.getUpTime();
    }

    @Override
    public void addRegionOwnedDiskStore(DiskStoreImpl dsi) {
        this.delegate.addRegionOwnedDiskStore(dsi);
    }

    @Override
    public DiskStoreMonitor getDiskStoreMonitor() {
        return this.delegate.getDiskStoreMonitor();
    }

    @Override
    public void close(String reason, Throwable optionalCause) {
        this.delegate.close(reason, optionalCause);
    }

    @Override
    public List<InternalCacheServer> getCacheServersAndGatewayReceiver() {
        return this.delegate.getCacheServersAndGatewayReceiver();
    }

    @Override
    public boolean isGlobalRegionInitializing(String fullPath) {
        return this.delegate.isGlobalRegionInitializing(fullPath);
    }

    @Override
    public DistributionAdvisor getDistributionAdvisor() {
        return this.delegate.getDistributionAdvisor();
    }

    @Override
    public void setQueryMonitorRequiredForResourceManager(boolean required) {
        this.delegate.setQueryMonitorRequiredForResourceManager(required);
    }

    @Override
    public boolean isQueryMonitorDisabledForLowMemory() {
        return this.delegate.isQueryMonitorDisabledForLowMemory();
    }

    @Override
    public boolean isRESTServiceRunning() {
        return this.delegate.isRESTServiceRunning();
    }

    @Override
    public InternalLogWriter getInternalLogWriter() {
        return this.delegate.getInternalLogWriter();
    }

    @Override
    public InternalLogWriter getSecurityInternalLogWriter() {
        return this.delegate.getSecurityInternalLogWriter();
    }

    @Override
    public Set<InternalRegion> getApplicationRegions() {
        return this.delegate.getApplicationRegions();
    }

    @Override
    public void removeGatewaySender(GatewaySender sender) {
        this.delegate.removeGatewaySender(sender);
    }

    @Override
    public DistributedLockService getGatewaySenderLockService() {
        return this.delegate.getGatewaySenderLockService();
    }

    @Override
    @VisibleForTesting
    public RestAgent getRestAgent() {
        return this.delegate.getRestAgent();
    }

    @Override
    public Properties getDeclarableProperties(Declarable declarable) {
        return this.delegate.getDeclarableProperties(declarable);
    }

    @Override
    public void setRESTServiceRunning(boolean isRESTServiceRunning) {
        this.delegate.setRESTServiceRunning(isRESTServiceRunning);
    }

    @Override
    public void close(String reason, boolean keepAlive, boolean keepDS) {
        this.delegate.close(reason, keepAlive, keepDS);
    }

    @Override
    public void addGatewayReceiver(GatewayReceiver receiver) {
        this.delegate.addGatewayReceiver(receiver);
    }

    @Override
    public void removeGatewayReceiver(GatewayReceiver receiver) {
        this.delegate.removeGatewayReceiver(receiver);
    }

    @Override
    public InternalCacheServer addGatewayReceiverServer(GatewayReceiver receiver) {
        return this.delegate.addGatewayReceiverServer(receiver);
    }

    @Override
    @VisibleForTesting
    public boolean removeCacheServer(CacheServer cacheServer) {
        return this.delegate.removeCacheServer(cacheServer);
    }

    @Override
    public boolean removeGatewayReceiverServer(InternalCacheServer receiverServer) {
        return this.delegate.removeGatewayReceiverServer(receiverServer);
    }

    @Override
    @VisibleForTesting
    public void setReadSerializedForTest(boolean value) {
        this.delegate.setReadSerializedForTest(value);
    }

    @Override
    public void setReadSerializedForCurrentThread(boolean value) {
        this.delegate.setReadSerializedForCurrentThread(value);
    }

    @Override
    public PdxInstanceFactory createPdxInstanceFactory(String className, boolean expectDomainClass) {
        return this.delegate.createPdxInstanceFactory(className, expectDomainClass);
    }

    @Override
    public void waitForRegisterInterestsInProgress() {
        this.delegate.waitForRegisterInterestsInProgress();
    }

    @Override
    public void reLoadClusterConfiguration() throws IOException, ClassNotFoundException {
        this.delegate.reLoadClusterConfiguration();
    }

    @Override
    public SecurityService getSecurityService() {
        return this.delegate.getSecurityService();
    }

    @Override
    public boolean hasPersistentRegion() {
        return this.delegate.hasPersistentRegion();
    }

    @Override
    public void shutDownAll() {
        this.delegate.shutDownAll();
    }

    @Override
    public void invokeRegionEntrySynchronizationListenersAfterSynchronization(InternalDistributedMember sender, InternalRegion region, List<InitialImageOperation.Entry> entriesToSynchronize) {
        this.delegate.invokeRegionEntrySynchronizationListenersAfterSynchronization(sender, region, entriesToSynchronize);
    }

    @Override
    public QueryService getQueryService() {
        return this.delegate.getQueryService();
    }

    @Override
    public InternalQueryService getInternalQueryService() {
        return this.delegate.getInternalQueryService();
    }

    @Override
    public JSONFormatter getJsonFormatter() {
        return this.delegate.getJsonFormatter();
    }

    @Override
    @VisibleForTesting
    public Set<AsyncEventQueue> getAsyncEventQueues(boolean visibleOnly) {
        return this.delegate.getAsyncEventQueues(visibleOnly);
    }

    @Override
    @VisibleForTesting
    public void closeDiskStores() {
        this.delegate.closeDiskStores();
    }

    @Override
    public Object convertPdxInstanceIfNeeded(Object obj, boolean preferCD) {
        return this.delegate.convertPdxInstanceIfNeeded(obj, preferCD);
    }

    @Override
    public Boolean getPdxReadSerializedOverride() {
        return this.delegate.getPdxReadSerializedOverride();
    }

    @Override
    public void setPdxReadSerializedOverride(boolean pdxReadSerialized) {
        this.delegate.setPdxReadSerializedOverride(pdxReadSerialized);
    }

    @Override
    public InternalCacheForClientAccess getCacheForProcessingClientRequests() {
        return this;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void throwCacheExistsException() {
        this.delegate.throwCacheExistsException();
    }

    @Override
    public MeterRegistry getMeterRegistry() {
        return this.delegate.getMeterRegistry();
    }

    @Override
    public void saveCacheXmlForReconnect() {
        this.delegate.saveCacheXmlForReconnect();
    }

    @Override
    @VisibleForTesting
    public HeapEvictor getHeapEvictor() {
        return this.delegate.getHeapEvictor();
    }

    @Override
    @VisibleForTesting
    public OffHeapEvictor getOffHeapEvictor() {
        return this.delegate.getOffHeapEvictor();
    }

    @Override
    public StatisticsClock getStatisticsClock() {
        return this.delegate.getStatisticsClock();
    }
}

