/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.alerting.internal;

import java.time.Instant;
import java.util.concurrent.ExecutorService;
import org.apache.geode.alerting.internal.AlertListenerMessageFactory;
import org.apache.geode.alerting.internal.AlertMessaging;
import org.apache.geode.alerting.internal.spi.AlertLevel;
import org.apache.geode.alerting.internal.spi.AlertingAction;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.admin.remote.AlertListenerMessage;
import org.apache.geode.internal.tcp.ReenteredConnectException;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ClusterAlertMessaging
implements AlertMessaging {
    private static final Logger logger = LogService.getLogger();
    private final InternalDistributedSystem system;
    private final DistributionManager dm;
    private final AlertListenerMessageFactory alertListenerMessageFactory;
    private final ExecutorService executor;

    public ClusterAlertMessaging(InternalDistributedSystem system) {
        this(system, system.getDistributionManager(), new AlertListenerMessageFactory(), LoggingExecutors.newFixedThreadPool((String)"AlertingMessaging Processor", (boolean)true, (int)1));
    }

    @VisibleForTesting
    ClusterAlertMessaging(InternalDistributedSystem system, DistributionManager dm, AlertListenerMessageFactory alertListenerMessageFactory, ExecutorService executor) {
        this.system = system;
        this.dm = dm;
        this.alertListenerMessageFactory = alertListenerMessageFactory;
        this.executor = executor;
    }

    @Override
    public void sendAlert(DistributedMember member, AlertLevel alertLevel, Instant timestamp, String threadName, long threadId, String formattedMessage, String stackTrace) {
        this.executor.submit(() -> AlertingAction.execute(() -> {
            try {
                String connectionName = this.system.getConfig().getName();
                AlertListenerMessage message = this.alertListenerMessageFactory.createAlertListenerMessage(member, alertLevel, timestamp, connectionName, threadName, threadId, formattedMessage, stackTrace);
                if (member.equals(this.system.getDistributedMember())) {
                    logger.debug("Processing local alert message: {}, {}, {}, {}, {}, {}, [{}], [{}].", (Object)member, (Object)alertLevel, (Object)timestamp, (Object)connectionName, (Object)threadName, (Object)threadId, (Object)formattedMessage, (Object)stackTrace);
                    this.processAlertListenerMessage(message);
                } else {
                    logger.debug("Sending remote alert message: {}, {}, {}, {}, {}, {}, [{}], [{}].", (Object)member, (Object)alertLevel, (Object)timestamp, (Object)connectionName, (Object)threadName, (Object)threadId, (Object)formattedMessage, (Object)stackTrace);
                    this.dm.putOutgoing(message);
                }
            }
            catch (ReenteredConnectException reenteredConnectException) {
                // empty catch block
            }
        }));
    }

    public void close() {
        this.executor.shutdownNow();
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
    }

    @VisibleForTesting
    void processAlertListenerMessage(AlertListenerMessage message) {
        this.verifyDistributionManagerCanProcessMessage();
        message.process((ClusterDistributionManager)this.dm);
    }

    private void verifyDistributionManagerCanProcessMessage() {
        if (!(this.dm instanceof ClusterDistributionManager)) {
            throw new IllegalArgumentException("Processing of AlertListenerMessage requires ClusterDistributionManager instead of " + this.dm.getClass().getSimpleName());
        }
    }
}

