/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.jmx.internal;

import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import org.apache.geode.admin.AdminException;
import org.apache.geode.admin.GemFireHealth;
import org.apache.geode.admin.internal.DistributedSystemHealthConfigImpl;
import org.apache.geode.admin.jmx.internal.GemFireHealthJmxImpl;
import org.apache.geode.admin.jmx.internal.MBeanUtil;
import org.apache.geode.admin.jmx.internal.ManagedResource;
import org.apache.geode.admin.jmx.internal.ManagedResourceType;

public class DistributedSystemHealthConfigJmxImpl
extends DistributedSystemHealthConfigImpl
implements ManagedResource {
    private GemFireHealth health;
    private String mbeanName;
    private ModelMBean modelMBean;
    private final ObjectName objectName;

    DistributedSystemHealthConfigJmxImpl(GemFireHealthJmxImpl health) throws AdminException {
        this.health = health;
        this.mbeanName = new StringBuffer().append("GemFire:type=").append("DistributedSystemHealthConfig,id=").append(MBeanUtil.makeCompliantMBeanNameProperty(health.getDistributedSystem().getId())).toString();
        this.objectName = MBeanUtil.createMBean(this);
    }

    public void applyChanges() {
        this.health.setDistributedSystemHealthConfig(this);
    }

    @Override
    public String getMBeanName() {
        return this.mbeanName;
    }

    @Override
    public ModelMBean getModelMBean() {
        return this.modelMBean;
    }

    @Override
    public void setModelMBean(ModelMBean modelMBean) {
        this.modelMBean = modelMBean;
    }

    @Override
    public ManagedResourceType getManagedResourceType() {
        return ManagedResourceType.DISTRIBUTED_SYSTEM_HEALTH_CONFIG;
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public void cleanupResource() {
    }
}

