/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.rmiio.util;

import com.healthmarketscience.rmiio.PacketInputStream;
import com.healthmarketscience.rmiio.PacketOutputStream;
import com.healthmarketscience.rmiio.util.PipeBuffer;
import com.healthmarketscience.rmiio.util.SingleByteAdapter;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class EncodingInputStream
extends PacketInputStream {
    public static final int DEFAULT_CHUNK_SIZE = 1024;
    private static final ByteBuffer DUMMY_FULL_BUFFER = ByteBuffer.wrap(EMPTY_PACKET);
    private final SingleByteAdapter _singleByteAdapter = new SingleByteAdapter();
    private ByteBuffer _curBuf;
    private final PipeBuffer _overflowBuf = new PipeBuffer(this.getPacketSize());
    private boolean _gotEOF = false;
    private volatile boolean _closed = false;

    protected EncodingInputStream() {
        this(1024);
    }

    protected EncodingInputStream(int chunkSize) {
        this(chunkSize, false);
    }

    protected EncodingInputStream(int chunkSize, boolean noDelay) {
        super(chunkSize, noDelay);
    }

    protected PacketOutputStream createOutputStream() {
        return new OutputStreamAdapter();
    }

    public void close() throws IOException {
        this._closed = true;
    }

    protected void throwIfClosed() throws IOException {
        if (this._closed) {
            throw new IOException("stream closed");
        }
    }

    public int available() throws IOException {
        this.throwIfClosed();
        this.refillPacket(true);
        return (int)this._overflowBuf.remaining();
    }

    public int read() throws IOException {
        this.throwIfClosed();
        return this._singleByteAdapter.read(this);
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] buf, int pos, int len) throws IOException {
        this.throwIfClosed();
        int numBytesRead = 0;
        if (this._overflowBuf.hasRemaining()) {
            int numBytes = Math.min((int)this._overflowBuf.remaining(), len);
            this._overflowBuf.read(buf, pos, numBytes);
            numBytesRead += numBytes;
            pos += numBytes;
            len -= numBytes;
        }
        if (len > 0) {
            this._curBuf = ByteBuffer.wrap(buf, pos, len);
            while (this._curBuf.hasRemaining() && !this._gotEOF) {
                this.encode(this._curBuf.remaining());
            }
            this._curBuf = null;
            if ((numBytesRead += len - this._curBuf.remaining()) == 0) {
                numBytesRead = -1;
            }
        }
        return numBytesRead;
    }

    public long skip(long len) throws IOException {
        long numBytes;
        this.throwIfClosed();
        if (len <= 0L) {
            return 0L;
        }
        long numBytesSkipped = 0L;
        if (this._overflowBuf.hasRemaining()) {
            numBytes = Math.min(this._overflowBuf.remaining(), len);
            this._overflowBuf.skip(numBytes);
            numBytesSkipped += numBytes;
            len -= numBytes;
        }
        while (len > 0L && !this._gotEOF) {
            numBytes = this.encodeSkip(len);
            numBytesSkipped += numBytes;
            len -= numBytes;
        }
        return numBytesSkipped;
    }

    private void refillPacket(boolean readPartial) throws IOException {
        if (!this._gotEOF && this._overflowBuf.packetsAvailable() == 0) {
            this._curBuf = DUMMY_FULL_BUFFER;
            do {
                this.encode(this.getPacketSize());
            } while (!this._gotEOF && (readPartial ? this._overflowBuf.remaining() == 0L : this._overflowBuf.packetsAvailable() == 0));
            this._curBuf = null;
        }
    }

    public byte[] readPacket(boolean readPartial) throws IOException {
        this.throwIfClosed();
        this.refillPacket(readPartial);
        byte[] packet = null;
        if (this._overflowBuf.hasRemaining()) {
            packet = this._overflowBuf.readPacket();
        } else if (!this._gotEOF) {
            if (!readPartial) {
                throw new AssertionError((Object)"invalid state");
            }
            packet = EMPTY_PACKET;
        }
        return packet;
    }

    public int packetsAvailable() throws IOException {
        this.throwIfClosed();
        return this._overflowBuf.packetsAvailable();
    }

    protected long encodeSkip(long len) throws IOException {
        this.refillPacket(true);
        long numBytesSkipped = 0L;
        if (this._overflowBuf.hasRemaining()) {
            numBytesSkipped = Math.min(this._overflowBuf.remaining(), len);
            this._overflowBuf.skip(numBytesSkipped);
        }
        return numBytesSkipped;
    }

    private void writeBuf(byte[] b, int pos, int len, boolean canKeep) {
        if (this._curBuf == null) {
            throw new IllegalStateException("Encoder is writing outside of call to encode");
        }
        int numBytes = Math.min(this._curBuf.remaining(), len);
        this._curBuf.put(b, pos, numBytes);
        if (numBytes < len) {
            if (!canKeep) {
                this._overflowBuf.write(b, pos + numBytes, len - numBytes);
            } else {
                this._overflowBuf.writePacket(b, pos + numBytes, len - numBytes);
            }
        }
    }

    private void closeOut() {
        this._gotEOF = true;
    }

    protected abstract void encode(int var1) throws IOException;

    private class OutputStreamAdapter
    extends PacketOutputStream {
        private final SingleByteAdapter _singleByteAdapter = new SingleByteAdapter();

        private OutputStreamAdapter() {
        }

        public void close() {
            EncodingInputStream.this.closeOut();
        }

        public void flush() {
        }

        public void write(int b) throws IOException {
            this._singleByteAdapter.write(b, this);
        }

        public void write(byte[] b) {
            EncodingInputStream.this.writeBuf(b, 0, b.length, false);
        }

        public void write(byte[] b, int pos, int len) {
            EncodingInputStream.this.writeBuf(b, pos, len, false);
        }

        public void writePacket(byte[] packet) {
            EncodingInputStream.this.writeBuf(packet, 0, packet.length, true);
        }
    }
}

