/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.messages;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.distributed.internal.membership.gms.messages.AbstractGMSMessage;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.Version;

public class JoinRequestMessage<ID extends MemberIdentifier>
extends AbstractGMSMessage<ID> {
    private ID memberID;
    private Object credentials;
    private int failureDetectionPort = -1;
    private int requestId;
    private boolean useMulticast;

    public JoinRequestMessage(ID coord, ID id, Object credentials, int fdPort, int requestId) {
        if (coord != null) {
            this.setRecipient(coord);
        }
        this.memberID = id;
        this.credentials = credentials;
        this.failureDetectionPort = fdPort;
        this.requestId = requestId;
    }

    public JoinRequestMessage() {
    }

    public int getRequestId() {
        return this.requestId;
    }

    public int getDSFID() {
        return -142;
    }

    @Override
    public boolean getMulticast() {
        return this.useMulticast;
    }

    @Override
    public void setMulticast(boolean useMulticast) {
        this.useMulticast = useMulticast;
    }

    public ID getMemberID() {
        return this.memberID;
    }

    public Object getCredentials() {
        return this.credentials;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.memberID + (this.credentials == null ? ")" : "; with credentials)") + " failureDetectionPort:" + this.failureDetectionPort;
    }

    public Version[] getSerializationVersions() {
        return null;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        context.getSerializer().writeObject(this.memberID, out);
        context.getSerializer().writeObject(this.credentials, out);
        out.writeInt(this.failureDetectionPort);
        out.writeBoolean(false);
        out.writeInt(this.requestId);
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.memberID = (MemberIdentifier)context.getDeserializer().readObject(in);
        this.credentials = context.getDeserializer().readObject(in);
        this.failureDetectionPort = in.readInt();
        in.readBoolean();
        this.requestId = in.readInt();
    }

    public int getFailureDetectionPort() {
        return this.failureDetectionPort;
    }

    public int hashCode() {
        return Objects.hash(this.memberID);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JoinRequestMessage other = (JoinRequestMessage)obj;
        if (this.credentials == null ? other.credentials != null : !this.credentials.equals(other.credentials)) {
            return false;
        }
        if (this.failureDetectionPort != other.failureDetectionPort) {
            return false;
        }
        if (this.memberID == null ? other.memberID != null : !this.memberID.equals(other.memberID)) {
            return false;
        }
        return this.requestId == other.requestId;
    }
}

