/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

@Internal
public final class WindowTimeIndictorInputTypeStrategy
implements InputTypeStrategy {
    private final TimestampKind timestampKind;

    public WindowTimeIndictorInputTypeStrategy(@Nullable TimestampKind timestampKind) {
        this.timestampKind = timestampKind;
    }

    @Override
    public ArgumentCount getArgumentCount() {
        return ConstantArgumentCount.of(1);
    }

    @Override
    public Optional<List<DataType>> inferInputTypes(CallContext callContext, boolean throwOnFailure) {
        LogicalType type = callContext.getArgumentDataTypes().get(0).getLogicalType();
        if (this.timestampKind == TimestampKind.PROCTIME && !LogicalTypeChecks.isTimeAttribute(type)) {
            return callContext.fail(throwOnFailure, "Reference to a rowtime or proctime window required.", new Object[0]);
        }
        if (this.timestampKind == TimestampKind.ROWTIME && LogicalTypeChecks.isProctimeAttribute(type)) {
            return callContext.fail(throwOnFailure, "A proctime window cannot provide a rowtime attribute.", new Object[0]);
        }
        if (!LogicalTypeChecks.canBeTimeAttributeType(type) && !type.is(LogicalTypeRoot.BIGINT)) {
            return callContext.fail(throwOnFailure, "Reference to a rowtime or proctime window required.", new Object[0]);
        }
        return Optional.of(callContext.getArgumentDataTypes());
    }

    @Override
    public List<Signature> getExpectedSignatures(FunctionDefinition definition) {
        return Collections.singletonList(Signature.of(Signature.Argument.ofGroup("WINDOW REFERENCE")));
    }
}

