/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.Signature;

@Internal
public class RepeatingSequenceInputTypeStrategy
implements InputTypeStrategy {
    private final List<ArgumentTypeStrategy> argumentStrategies;

    public RepeatingSequenceInputTypeStrategy(List<ArgumentTypeStrategy> argumentStrategies) {
        this.argumentStrategies = argumentStrategies;
    }

    @Override
    public ArgumentCount getArgumentCount() {
        return new ArgumentCount(){

            @Override
            public boolean isValidCount(int count) {
                return count % RepeatingSequenceInputTypeStrategy.this.argumentStrategies.size() == 0;
            }

            @Override
            public Optional<Integer> getMinCount() {
                return Optional.empty();
            }

            @Override
            public Optional<Integer> getMaxCount() {
                return Optional.empty();
            }
        };
    }

    @Override
    public Optional<List<DataType>> inferInputTypes(CallContext callContext, boolean throwOnFailure) {
        List<DataType> dataTypes = callContext.getArgumentDataTypes();
        ArrayList<DataType> inferredDataTypes = new ArrayList<DataType>(dataTypes.size());
        for (int i = 0; i < callContext.getArgumentDataTypes().size(); ++i) {
            ArgumentTypeStrategy argumentStrategy = this.argumentStrategies.get(i % this.argumentStrategies.size());
            Optional<DataType> inferredDataType = argumentStrategy.inferArgumentType(callContext, i, throwOnFailure);
            if (!inferredDataType.isPresent()) {
                return Optional.empty();
            }
            inferredDataTypes.add(inferredDataType.get());
        }
        return Optional.of(inferredDataTypes);
    }

    @Override
    public List<Signature> getExpectedSignatures(FunctionDefinition definition) {
        ArrayList<Signature.Argument> arguments = new ArrayList<Signature.Argument>();
        for (int i = 0; i < this.argumentStrategies.size(); ++i) {
            Signature.Argument argument = this.argumentStrategies.get(i).getExpectedArgument(definition, i);
            Signature.Argument newArgument = i == 0 ? Signature.Argument.of(String.format("[%s", argument.getType())) : (i == this.argumentStrategies.size() - 1 ? Signature.Argument.of(String.format("%s]...", argument.getType())) : argument);
            arguments.add(newArgument);
        }
        Signature signature = Signature.of(arguments);
        return Collections.singletonList(signature);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RepeatingSequenceInputTypeStrategy that = (RepeatingSequenceInputTypeStrategy)other;
        return Objects.equals(this.argumentStrategies, that.argumentStrategies);
    }

    public int hashCode() {
        return Objects.hash(this.argumentStrategies);
    }
}

