/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.inference.strategies.StrategyUtils;
import org.apache.flink.table.types.logical.LogicalTypeFamily;

@Internal
public final class ArrayElementTypeStrategy
implements TypeStrategy {
    @Override
    public Optional<DataType> inferType(CallContext callContext) {
        DataType arrayType = callContext.getArgumentDataTypes().get(0);
        Optional<DataType> legacyArrayElement = StrategyUtils.extractLegacyArrayElement(arrayType);
        if (legacyArrayElement.isPresent()) {
            return legacyArrayElement;
        }
        if (!arrayType.getLogicalType().is(LogicalTypeFamily.COLLECTION)) {
            return Optional.empty();
        }
        return Optional.of(((CollectionDataType)arrayType).getElementDataType().nullable());
    }
}

