/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.ddl.AlterViewOperation;

@Internal
public class AlterViewAsOperation
extends AlterViewOperation {
    private final CatalogView newView;

    public AlterViewAsOperation(ObjectIdentifier viewIdentifier, CatalogView newView) {
        super(viewIdentifier);
        this.newView = newView;
    }

    public CatalogView getNewView() {
        return this.newView;
    }

    @Override
    public String asSummaryString() {
        return String.format("ALTER VIEW %s AS %s", this.viewIdentifier.asSummaryString(), this.newView.getOriginalQuery());
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        ctx.getCatalogManager().alterTable(this.getNewView(), this.getViewIdentifier(), false);
        return TableResultImpl.TABLE_RESULT_OK;
    }
}

